%=======================================================%
% Programmer: Tsung-Han Chan
% National Tsing Hua University, Hsinchu, Taiwan 
% E-mail: chantsunghan@gmail.com
% Date: Sept. 10, 2009
% -------------------------------------------------------
% Reference: 
% W.-K. Ma, T.-H. Chan, C.-Y. Chi, and Y. Wang, Convex analysis for
% non-negative blind source separation with application in imaging, 
% a Chapter (37 pages) to appear in Convex Optimization in Signal 
% Processing and Communications (edited by D. P. Palomar and Y. C. Eldar), 
% Cambridge University Press, 2009.
%=======================================================
% This is a simple example for human face separation using CAMNS-AVM algorithm
% N is number of sources
% M is number of observations (sensors)

clear all;close all;clc
N=3;
M=3; 
%=============Read images===============
image1=double(imread('zhang1.jpg'));
image11=image1/255;
image2=double(imread('cao1.jpg'));
image22=image2/255;
image3=double(imread('ksiwek1.jpg'));
image33=image3/255;
[m,n]=size(image1);
L=m*n; % data length
s1=vec(image11);
s2=vec(image22);
s3=vec(image33);
SS=[s1 s2 s3]'; % source matrix N by L
%===========randomly unit row-sum mixing matrix===========
AA=rand(N,M);
A=(AA./(ones(N,1)*sum(AA))).'; % mixing matrix
X=A*SS;       % observation matrix M by L
%-------------------------------------------------
Y=CAMNS_AVM(X',N);
% %============vector to matrix (image)=================
X1=reshape(X(1,:),m,n);
X2=reshape(X(2,:),m,n);
X3=reshape(X(3,:),m,n);
Y1=reshape(Y(:,1),m,n);
Y2=reshape(Y(:,2),m,n);
Y3=reshape(Y(:,3),m,n);
% % %==========plotting===============
figure;subplot(1,3,1);imshow(image11);
subplot(1,3,2);imshow(image22);title('Original sources');subplot(1,3,3);imshow(image33);
figure;subplot(1,3,1);imshow(X1);
subplot(1,3,2);imshow(X2);title('Source mixtures');subplot(1,3,3);imshow(X3);
figure; subplot(1,3,1);imshow(Y1);
subplot(1,3,2);imshow(Y2);title('Extracted sources by CAMNS_{AVM}');subplot(1,3,3);imshow(Y3);

