package organization.beliefSystem.dataschema;

import organization.communicationOntology.Order;
import organization.dataschema.Clock;

public class DataO {
	public String cusName;
	public String pName;
	public String spec;
	public double setupTime;
	public double unitTime;
	public double constantOfOrderUpTo;
	public double constantFunction;
	public float capacity;

	public ForecastRecord[][] f;
	public InhouseRecord[][] ih;
	public OutsourceRecord[][] o;

	// set the productName, spec, time length and slot length
	public DataO(String _customer, String _pName, String _spec, int _tLength,
			int _sLength, double _setupTime, double _unitTime,
			double _constantOfOrderUpTo, double _constantFunction,
			float _capacity) {
		cusName = _customer;
		pName = _pName;
		spec = _spec;
		setupTime = _setupTime;
		unitTime = _unitTime;
		constantOfOrderUpTo = _constantOfOrderUpTo;
		constantFunction = _constantFunction;
		capacity = _capacity;
		initializeDataArray(_tLength, _sLength);
	}

	private void initializeDataArray(int _tLength, int _sLength) {
		f = new ForecastRecord[_tLength][_sLength];
		for (int i = 0; i < _tLength; i++)
			for (int j = 0; j < _sLength; j++)
				f[i][j] = new ForecastRecord();
		ih = new InhouseRecord[_tLength][_sLength];
		for (int i = 0; i < _tLength; i++)
			for (int j = 0; j < _sLength; j++)
				ih[i][j] = new InhouseRecord();
		o = new OutsourceRecord[_tLength][_sLength];
		for (int i = 0; i < _tLength; i++)
			for (int j = 0; j < _sLength; j++)
				o[i][j] = new OutsourceRecord();
	}

	public void recordDemand(Order _order) {
		int quantity = _order.getInquiry().getActivity().getQuantity();
		String orderPlacingTime = _order.getOrderPlacingDatetime();
		int t = Clock.getPeriod(orderPlacingTime);
		int ts = Clock.getSlot(orderPlacingTime);
		o[t][ts].actualDemandInSlot = quantity;
		o[t][o[t].length - 1].totalDemandInPeriod += quantity;
	}

}
