package organization.beliefSystem.dataschema;

import organization.dataschema.Clock;

public class DataS {
	public String pName;
	public String spec;

	public double setupTime;
	public double unitTime;
	public float capacity;

	public InhouseRecord[][] ih;
	public int[][] orderQuantity;
	
	public DataS(String _pName, String _spec, int _tLength,
			int _sLength) {
		pName = _pName;
		spec = _spec;
		initializeDataArray(_tLength, _sLength);
	}
	
	private void initializeDataArray(int _tLength, int _sLength) {
		ih = new InhouseRecord[_tLength][_sLength];
		for (int i = 0; i < _tLength; i++)
			for (int j = 0; j < _sLength; j++)
				ih[i][j] = new InhouseRecord();
		orderQuantity = new int[_tLength][_sLength];
	}

	public void recordDemand(OrderData _order) {
		int quantity = _order.quantity;
		int t = Clock.getPeriod();
		int ts = Clock.getSlot();
		orderQuantity[t][ts] = quantity;
	}

}
