package organization.beliefSystem;

import swarm.Selector;
import swarm.defobj.Zone;
import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.activity.ActionGroupImpl;
import swarm.activity.ScheduleImpl;
import swarm.activity.Activity;

import java.util.List;
import java.util.ArrayList;

import organization.OrganizationImpl;
import organization.communicationOntology.Order;
import organization.dataschema.*;
import organization.beliefSystem.dataschema.*;

public class swarmBusinessEnvironment extends SwarmImpl {
	public int simulationTimeLength;
	public int methodType;
	public int timePeriodLength;
	public int timeSlotLength;
	public int winSize;
	public double constantOfOrderUpTo;
	public double constantFunction;
	
	private int startSimulationTime;

	private OrganizationImpl org;
	public swarmOrganization self;
	private List suppliers;
	private List customers;
	
	public ScheduleImpl modelSchedule;

	public boolean simulationFinished;
	
	private List outsources;

	public swarmBusinessEnvironment(Zone arg0) {
		super(arg0);
		suppliers = new ArrayList();
		customers = new ArrayList();
	}

	public Object buildObjects(OrganizationImpl _org) {
		super.buildObjects();
		org = _org;
		buildSupplierObjects();
		buildCustomerObjects();
		self = new swarmOrganization(this);
		return this;
	}

	public OrganizationImpl getOrganization() {
		return this.org;
	}

	private void buildSupplierObjects() {
		List s = this.org.suppliers;
		for (int i = 0; i < s.size(); i++) {
			classSupplier supplier = (classSupplier) s.get(i);
			supplierSwarm sup = new supplierSwarm(supplier, this);
			this.suppliers.add(sup);
		}
	}

	private void buildCustomerObjects() {
		List c = this.org.customers;
		for (int i = 0; i < c.size(); i++) {
			classCustomer customer = (classCustomer) c.get(i);
			customerSwarm cus = new customerSwarm(customer, timePeriodLength,
					timeSlotLength, winSize, methodType, constantFunction);
			this.customers.add(cus);
		}
	}

	public Object buildActions() {
		Selector sel;
		ActionGroupImpl modelActions;
		customerSwarm customer;
		
		super.buildActions();	
		
		modelActions = new ActionGroupImpl(getZone());
		try {
			for (int i = 0; i <customers.size(); i++) {
				customer = (customerSwarm) this.customers.get(i);
				sel = new Selector(customer.getClass(), "forecastDemand",
						false);
				modelActions.createActionTo$message(customer, sel);
				
				sel = new Selector(customer.getClass(),
						"computeStandardDeviation", false);
				modelActions.createActionTo$message(customer, sel);
			}
			sel = new Selector(self.getClass(),	"computePurchaseQuantity", false);
			modelActions.createActionTo$message(self, sel);
			
			sel = new Selector(self.getClass(), "computeLeadtimeOfMakeQuantityInPeriod", false);
			modelActions.createActionTo$message(self, sel);
			
			sel = new Selector(self.getClass(),	"generateOutsources", false);
			modelActions.createActionTo$message(self, sel);	
			
			sel = new Selector(self.getClass(),	"computeQuantityOfFinishedGoods", false);
			modelActions.createActionTo$message(self, sel);
			
			sel = new Selector(self.getClass(), "computeShortage", false);
			modelActions.createActionTo$message(self, sel);			
			sel = new Selector(self.getClass(),	"generateDeliveries", false);
			modelActions.createActionTo$message(self, sel);
			
			sel = new Selector(this.getClass(), "generateOrders", false);
			modelActions.createActionTo$message(this, sel);

			sel = new Selector(self.getClass(), "outputData", false);
			modelActions.createActionTo$message(self, sel);

			sel = new Selector(this.getClass(), "checkTime", false);
			modelActions.createActionTo$message(this, sel);

		} catch (Exception e) {
			e.printStackTrace(System.err);
		}

		//
		// create the model sechedual with a repeat interval of 1
		// all actions will be executed at each time step
		//

		modelSchedule = new ScheduleImpl(getZone(), 1);
		modelSchedule.at$createAction(0, modelActions);

		return this;
	}

	//	This method specifies the context in which the model is to be run.
	public Activity activateIn(Swarm swarmContext) {
		super.activateIn(swarmContext);
		modelSchedule.activateIn(this);
		return getActivity();
	}

	public void checkTime() {
		startSimulationTime++;
		if (startSimulationTime == simulationTimeLength) {
			(getActivity().getSwarmActivity()).stop();
			simulationFinished = true;
		}
	}

	public Object go() {
		startSimulationTime = 0;	
		simulationFinished = false;
		(getActivity().getSwarmActivity()).run();
		return getActivity().getStatus();
	}
	
	public List getSuppliers() {
		return this.suppliers;
	}

	public List getCustomers() {
		return this.customers;
	}


	public void recordCustomerOrder(Order _order) {
		String customerName = _order.getInquiry().getSender().getName();
		for (int i = 0; i < this.customers.size(); i++) {
			customerSwarm customer = (customerSwarm) customers.get(i);
			if (customer.name.equals(customerName)) {
				customer.recordDemand(_order);
				break;
			}
		}
	}
	
	public void generateOrders() {
		outsources = self.generateOrders();
		for (int i=0; i<outsources.size();i++){
			OrderData order = (OrderData) outsources.get(i);
			placeOutsource(order);
		}
	}
	
	private void placeOutsource(OrderData _order) {
		classSupplier cs = _order.cs;
		String supplierName = cs.getName();
		for (int i=0; i<suppliers.size();i++){
			supplierSwarm supplier = (supplierSwarm) suppliers.get(i);
			if (supplierName.equals(supplier.name)){
				supplier.receiveOrder(_order);
				break;
			}
		}
	}
	
	public List getOutsources() {
		do {} while (!simulationFinished);
		return outsources;
	}
	
	public List getInhousePlanning() {
		return self.getInhousePlanning();
	}

}
