package organization.operation.sales;

import organization.communicationOntology.Inquiry;
import organization.communicationOntology.Order;
import organization.communicationOntology.OrderAcknowledgement;
import organization.communicationOntology.Proposal;
import organization.dataschema.classProject;
import organization.dataschema.Clock;
import organization.operation.setting;

public class OrderManagement {
	private SalesManager sm;

	public OrderManagement(SalesManager _sm) {
		this.sm = _sm;
	}

	//outsource directly, outsource after simulation, outsource after inquires
	public void recieveOrder(Order _order, int _op_fulfill, int _op_OFP) {
		boolean isInquired = isInquired(_order);
		this.sm.recordOrder(_order);
		if (!isInquired) {
			Proposal proposal = this.generateProposal(_order);
			_order.setProposal(proposal);
			if (_op_fulfill == setting.FULFILL_ORDER_DIRECTLY)
				fulfillOrderDirectly(_order, _op_OFP);
			else if (_op_fulfill == setting.FULFILL_ORDER_AFTER_SIMULATION)
				fulfillOrderAfterSimulation(_order, _op_OFP);

			else if (_op_fulfill == setting.FULFILL_ORDER_AFTER_FURTHER_INQUIRY)
				fulfillOrderAfterPlanning(_order, _op_OFP);
		} else
			fulfillOrderBasedOnPriorPlanning(_order);
//		OrderAcknowledgement oa = getOrderAcknowledgement(_order);
//		this.sm.deliverOrderAcknowledgement(oa);
	}
	
	public Proposal generateProposal(Order _order) {
		int op_propose = setting.PROPOSE_DIRECTLY;
		int op_OFP = setting.GET_PROCESS_DEFAULT;
		return this.generateProposal(_order, op_propose, op_OFP);
	}

	public Proposal generateProposal(Order _order, int _op_propose) {
		int op_OFP = setting.GET_PROCESS_DEFAULT;
		return this.generateProposal(_order, _op_propose, op_OFP);
	}

	public Proposal generateProposal(Order _order, int _op_propose, int _op_OFP) {
		Inquiry inquiry = _order.getInquiry();
		return this.sm.generateProposal(inquiry, _op_propose, _op_OFP);
	}

	private void fulfillOrderDirectly(Order _order, int _op_OFP) {
		classProject cp = this.sm.getOFP(_order, _op_OFP);
		if (cp != null) {
			cp = this.sm.generateInquiry(cp);
			cp = this.sm.generateAllOrder(cp);
			cp = this.sm.planEstimatedSchedule(cp);
			cp.cost = this.sm.getEstimatedCost(cp);
			cp.price = this.sm.getPrice(cp);

			this.sm.recordClassProcess(cp);
			this.sm.deliverOrder(cp);
			this.sm.scheduleInhouseActivity(cp);
		}
	}

	private void fulfillOrderAfterSimulation(Order _order, int _op_OFP) {
		classProject cp = this.sm.getOFP(_order, _op_OFP);
		cp = this.sm.simulateComingOrder(cp);

		cp = this.sm.generateAllOrder(cp);
		cp = this.sm.planEstimatedSchedule(cp);
		cp.cost = this.sm.getEstimatedCost(cp);
		cp.price = this.sm.getPrice(cp);

		this.sm.recordClassProcess(cp);
		this.sm.deliverOrder(cp);
		this.sm.scheduleInhouseActivity(cp);
	}

	private void fulfillOrderAfterPlanning(Order _order, int _op_OFP) {
		classProject cp = this.sm.getOFP(_order, _op_OFP);
		cp = this.sm.generateInquiry(cp);

		this.sm.recordClassProcess(cp);
		this.sm.deliverInquiry(cp);
		this.sm.planInhouseActivity(cp);
	}

	private void fulfillOrderBasedOnPriorPlanning(Order _order) {
		this.sm.fulfillOrderBasedOnPriorPlanning(_order);
	}

	public OrderAcknowledgement getOrderAcknowledgement(Order _order) {
		String datetime = Clock.getTime();
		OrderAcknowledgement oa = new OrderAcknowledgement(_order, datetime);
		return oa;
	}

	private boolean isInquired(Order _order) {
		boolean result = false;
		//		String inqNo = _order.getInquiry().getInqNo();
		//		String receiver = _order.getInquiry().getReceiver().getName();
		return result;
	}
}
