package organization.beliefSystem;

import java.util.List;
import organization.dataschema.*;
import organization.beliefSystem.dataschema.*;

public class customerPurchasing {
	customerSwarm customer;
	methodForecast[] method;

	private int winSize;
	private List memory;
	private int methodType;


	public customerPurchasing(int _winSize, customerSwarm _customer) {
		customer = _customer;
		memory = customer.memory;
		methodType = customer.methodType;
		winSize = _winSize;
		if (methodType==1){
			method = new method1[memory.size()];
			for (int i=0; i<memory.size();i++){
				DataC rc = (DataC)memory.get(i);
				method[i]=new method1(winSize, rc);
			}
		}
		else if (methodType==2) {
			method = new method2[memory.size()];
			for (int i=0; i<memory.size();i++){
				DataC rc = (DataC)memory.get(i);
				method[i]=new method2(winSize, rc);
			}
		}
		else {
			method = new method3[memory.size()];
			for (int i=0; i<memory.size();i++){
				DataC rc = (DataC) memory.get(i);
				method[i]=new method3(winSize, rc);
			}
		}
		
	}

	public void forecastDemand(int _index) {
		int demand = 0;
		int t = Clock.getPeriod();
		int ts = Clock.getSlot();
		DataC rc = (DataC) memory.get(_index);
		if (_index > -1)
			demand = method[_index].generateDemand(t, ts, rc);
		rc.f[t][ts].forecastedCustomerDemandInSlot = demand;
		rc.f[t][ts].forecastedCustomerDemandInPeriod +=demand;

	}

	public void forecastDemand() {
		int ts = Clock.getSlot();
		if ((methodType==3)|(ts==customer.timeSlotLength-1))
			for (int i = 0; i < this.memory.size(); i++)
				forecastDemand(i);
	}

	public void computeStandardDeviation() {
		int ts = Clock.getSlot();
		if ((methodType==3)|(ts==customer.timeSlotLength-1))
			for (int i = 0; i < this.memory.size(); i++)
				computeStandardDeviation(i);
		
	}

	public void computeStandardDeviation(int _index) {
		int t = Clock.getPeriod();
		int ts = Clock.getSlot();
		int frameBeginning = t - this.winSize;
		if (frameBeginning < 0)
			frameBeginning = 0;
		DataC rc = (DataC) memory.get(_index);

		double onePeriodErrorAcc = 0;

		ForecastRecord[][] forecast = rc.f;
		OutsourceRecord[][] outsource = rc.o;

		for (int i = frameBeginning; i < t; i++) {
			onePeriodErrorAcc += Math.pow(outsource[i][ts].actualDemandInSlot
					- forecast[i][ts].forecastedCustomerDemandInSlot, 2);
		}
		forecast[t][ts].standardDeviation = rc.constantFunction
				* Math.sqrt(onePeriodErrorAcc / (t - frameBeginning));
	}

}
