package organization.beliefSystem;

import java.util.List;
import java.util.ArrayList;

import swarm.objectbase.SwarmObjectImpl;

import organization.dataschema.*;
import organization.beliefSystem.dataschema.*;
import organization.communicationOntology.*;

public class customerSwarm extends SwarmObjectImpl {
	public String name = null;

	public customerPurchasing purchasing;

	public List memory;
	public int methodType;
	public int timeSlotLength;

	public customerSwarm(classCustomer _customer, int _tLength, int _sLength,
			int _winSize, int _methodType, double _constantFunction) {
		memory = new ArrayList();
		this.name = _customer.getName();
		this.methodType = _methodType;
		this.timeSlotLength = _sLength;
		List product = _customer.requestProduct;
		DataC r;
		for (int i = 0; i < product.size(); i++) {
			classRequestProduct crp = (classRequestProduct) product.get(i);
			r = new DataC(crp.name, crp.spec, _constantFunction,_tLength, _sLength);
			memory.add(r);
		}
		purchasing = new customerPurchasing(_winSize, this);
	}

	public void recordDemand(Order _order) {
		String pName = _order.getInquiry().getActivity().getName();
		String spec = _order.getInquiry().getActivity().getSpec();
		DataC rc = null;
		for (int i = 0; i < memory.size(); i++) {
			rc = (DataC) memory.get(i);
			if (rc.pName.equals(pName) & rc.spec.equals(spec)) {
				rc.recordDemand(_order);
				break;
			}
		}
	}

	public void forecastDemand() {
		this.purchasing.forecastDemand();
	}

	public void computeStandardDeviation() {
		this.purchasing.computeStandardDeviation();
		}

}
