package organization.dataschema;

import java.util.List;
import organization.communicationOntology.Activity;
import organization.communicationOntology.Inquiry;
import organization.communicationOntology.Order;

public class classProject {
	public String name;

	private Object inqOrd;

	public String startActivityName;

	public String endActivityName;

	public String startingDatetime;

	public String endingDatetime;

	public int quantityAvailable; //wƶq

	public int cost;

	public int price;

	public List workflow;

	public classProject(String _name, Object _obj, String _startActivityName,
			String _endActivityName) {
		this.name = _name;
		this.inqOrd = _obj;
		this.startActivityName = _startActivityName;
		this.endActivityName = _endActivityName;
	}

	public Activity getActivity() {
		Activity activity = null;
		if (this.inqOrd instanceof Inquiry)
			activity = ((Inquiry) this.inqOrd).getActivity();
		else if (this.inqOrd instanceof Order)
			activity = ((Order) this.inqOrd).getInquiry().getActivity();
		return activity;
	}

	public int getQuantity() {
		int quantity = 0;
		if (this.inqOrd instanceof Inquiry)
			quantity = getActivity().getQuantity();
		else if (this.inqOrd instanceof Order)
			quantity = ((Order) this.inqOrd).getAgreedProposal()
					.getTotalQuantity();
		return quantity;
	}

	public Order getOrder() {
		Order order = null;
		if (this.inqOrd instanceof Order)
			order = (Order) this.inqOrd;
		return order;
	}

	public Inquiry getInquiry() {
		Inquiry inquiry = null;
		if (this.inqOrd instanceof Inquiry)
			inquiry = (Inquiry) this.inqOrd;
		else if (this.inqOrd instanceof Order)
			inquiry = ((Order) this.inqOrd).getInquiry();
		return inquiry;
	}

	public String getInqNo() {
		String inqNo = null;
		if (this.inqOrd instanceof Inquiry)
			inqNo = ((Inquiry) this.inqOrd).getInqNo();
		else if (this.inqOrd instanceof Order)
			inqNo = ((Order) this.inqOrd).getInquiry().getInqNo();
		return inqNo;
	}

	public float getQualityLevel() {
		return this.getInquiry().getQualityLevel();
	}

	public classActivity getClassActivity(String _name) {
		classActivity ca = null;
		for (int i = 0; i < this.workflow.size(); i++) {
			classActivity caTemp = (classActivity) this.workflow.get(i);
			if (_name.equals(caTemp.name)) {
				ca = caTemp;
				break;
			}
		}
		return ca;
	}
}