package organization.operation.inhouse;

import organization.operation.OperationHub;
import organization.operation.Department;
import organization.dataschema.*;
import java.util.List;
import organization.beliefSystem.dataschema.*;

public class ManufacturingManager extends Department {

	public ManufacturingManager(OperationHub _ipi) {
		super(_ipi);
	}

	
	public void planInhouseActivities(List _inhousePlannings) {
		for (int i=0; i<_inhousePlannings.size();i++){
			InhouseData inhouseD = (InhouseData) _inhousePlannings.get(i);
			String cusName = inhouseD.customerName;
			String pName = inhouseD.pName;
			int makeQuantity = inhouseD.makeQuantity;
			String[] productParameters = 
				org.getProductParameters(cusName, pName);

			double setupTime = Double.parseDouble(productParameters[0]);
			double unitProductionTime = Double.parseDouble(productParameters[1]);
			double capacity = Double.parseDouble(productParameters[2]);

//setupTime, unitProductionTime, capacity should refer to real manufacturing system
			
			int leadtimeOfMakeQuantity = (int) Math.ceil((setupTime + makeQuantity
					* unitProductionTime)/capacity);
			
			classInhouseRecord cir = new classInhouseRecord(inhouseD.requestedQuantity,
					inhouseD.forecastedQuantity, inhouseD.makeQuantity,
					leadtimeOfMakeQuantity);
			
			ohub.datam.storeInhouseData(inhouseD, cir);
		}
	}

	

}
