package organization.operation.purchasing;

import java.util.List;

import organization.communicationOntology.*;
import organization.dataschema.*;

public class InquiryManagement {
	PurchasingManager om;

	private int dailySeqNo;

	public InquiryManagement(PurchasingManager _om) {
		this.om = _om;

		this.dailySeqNo = 0;
	}

	public void resetDailySeqNo() {
		this.dailySeqNo = 0;
	}

	public classProject generateInquiry(classProject _cp) {
		List workflow = _cp.workflow;
		float qualityLevel = _cp.getInquiry().getQualityLevel();

		String dateSeq = this.om.org.name + Clock.gen4digitSeqNo(Clock.period);
		Company sender = new Company(this.om.org.name, this.om.org.agentName);

		for (int i = 0; i < workflow.size(); i++) {
			classActivity ca = (classActivity) workflow.get(i);
			Object obj = ca.assignedFulfillmentMethod;
			if (obj instanceof classOutsourcingActivity) {
				classOutsourcingActivity coa = (classOutsourcingActivity) obj;
				String inqNo = dateSeq + this.om.org.name
						+ Clock.gen4digitSeqNo(this.dailySeqNo++);
				String receiverName = coa.supplier;
				Company receiver = this.om.getSupplier(receiverName);
				Activity activity = new Activity(ca.name, ca.spec,
						ca.quantityRequired);
				String requiredDatetime = this.om.getRequiredDatetime(ca);
				Inquiry inq = new Inquiry(inqNo, receiver, sender, activity,
						Clock.getTime(), requiredDatetime, qualityLevel);
				ca.inqOrd = inq;
			}
		}
		return _cp;
	}

}
