package organization;



import java.util.List;

import swarm.Globals;
import swarm.objectbase.SwarmImpl;

import organization.beliefSystem.swarmBusinessEnvironment;
import organization.communicationOntology.*;

public class SimulatedAgentImpl extends SwarmImpl {
	public OrganizationImpl org;

	public swarmBusinessEnvironment swarmModel;

	public SimulatedAgentImpl(OrganizationImpl _org, String[] _args) {
		this.org = _org;
		Globals.env.initSwarm("simulation", "1.0",
				"d9042805@student.nsysu.edu.tw", _args);
		swarmModel = (swarmBusinessEnvironment) Globals.env.lispAppArchiver
		        .getWithZone$key(Globals.env.globalZone, "model");
		swarmModel.buildObjects(this.org);
		swarmModel.buildActions();
		swarmModel.activateIn(null);
	}

	public void simulateSupplyChain() {
		swarmModel.go();
	}
	
	public void destroySwarmModel() {
		swarmModel.drop();
	}

	public void receiveOrder(Order _order) {
		swarmModel.recordCustomerOrder(_order);
	}
	
	public List getOrdersToSuppliers() {
		return swarmModel.getOutsources();
	}
	
	public List getInhousePlanning() {
		return swarmModel.getInhousePlanning();
	}
	
}
