package organization.beliefSystem;

import swarm.objectbase.SwarmObjectImpl;
import swarm.activity.ScheduleImpl;

import organization.OrganizationImpl;
import organization.dataschema.*;
import organization.beliefSystem.dataschema.*;

import java.util.*;

public class swarmOrganization extends SwarmObjectImpl {
	private int timePeriodLength;
	private int timeSlotLength;
	private int winSize;

	private double constantOfOrderUpTo;
	private double constantFunction;

	private sales sales;
	private outsourcing outsourcing;
	private inhouse inhouse;
	private inventory inventory; //reserved for future use
	private process process;
	private delivery delivery;

	public ScheduleImpl modelSchedule;

	public List memory; //for every product of every customer

	public swarmBusinessEnvironment env;

	public OrganizationImpl org;

	private List newOutsources;
	private List deliveries;

	public swarmOrganization(swarmBusinessEnvironment _env) {
		env = _env;
		org = env.getOrganization();

		timePeriodLength = env.timePeriodLength;
		timeSlotLength = env.timeSlotLength;
		winSize = env.winSize;
		constantOfOrderUpTo = env.constantOfOrderUpTo;
		constantFunction = env.constantFunction;
		initializeMemory();
		buildObjects();
	}

	private void initializeMemory() {
		memory = new ArrayList();
		List customers = org.customers;
		for (int i = 0; i < customers.size(); i++) {
			classCustomer customer = (classCustomer) customers.get(i);
			String customerName = customer.getName();
			List requestProducts = customer.requestProduct;
			for (int j=0; j<requestProducts.size(); j++) {
				classRequestProduct crp = (classRequestProduct) requestProducts
						.get(j);
				String pName = crp.name;
				String spec = crp.spec;
				String[] str = org.getProductParameters(customerName, pName);
				double setupTime = Double.parseDouble(str[0]);
				double unitTime = Double.parseDouble(str[1]);
				float capacity = Float.parseFloat(str[2]);
				DataO r = new DataO(customerName, pName, spec,
						timePeriodLength, timeSlotLength, setupTime, unitTime,
						constantOfOrderUpTo, constantFunction, capacity);
				memory.add(r);
			}
		}
	}

	private void buildObjects() {
		this.sales = new sales(this);
		this.outsourcing = new outsourcing(winSize, this);
		this.inhouse = new inhouse(this);
		this.inventory = new inventory(this);
		this.process = new process(this);
		this.delivery = new delivery(this);
	}

	public void computePurchaseQuantity() {
		int ts = Clock.getSlot();
		int methodType = env.methodType;
		if ((methodType==3)|(ts == timeSlotLength - 1)) {
			List customers = env.getCustomers();
			for (int i=0; i<customers.size();i++){
				customerSwarm customer = (customerSwarm) customers.get(i);
				sales.computePurchaseQuantity(customer);
			}
		}
	}
	
	public void computeLeadtimeOfMakeQuantityInPeriod() {
		int methodType = env.methodType;
		int ts = Clock.getSlot();
		if ((methodType==3)|(ts == timeSlotLength-1))
			inhouse.computeLeadtimeOfMakeQuantityInPeriod();
	}

	public void computeShortage() {
		int methodType = env.methodType;
		int ts = Clock.getSlot();
		if ((methodType==3)|(ts == timeSlotLength-1))
			inhouse.computeShortage();
	}

	public List generateOrders(){
		return newOutsources;
	}

	public void generateOutsources() {
		newOutsources = new ArrayList();
		int methodType = env.methodType;
		int ts = Clock.getSlot();
		if ((methodType==3)|(ts==timeSlotLength-1))
			newOutsources = outsourcing.generateOutsources();
	}

	public void computeQuantityOfFinishedGoods() {
		int ts = Clock.getSlot();
		if (ts == timeSlotLength-1)
			inhouse.computeQuantityOfFinishedGoods();
	}

	public void generateDeliveries() {
		deliveries = new ArrayList();
		int ts = Clock.getSlot();
		if (ts == timeSlotLength-1)
			deliveries = delivery.getDeliveries();
	}

	public classAct getWorkflow(DataO _r) {
		return (classAct) process.getWorkflow(_r);
	}

//	reserved for future use
	public List getSimulatedOFP(int _t, int _ts) {
		return process.getWorkflows(_t, _ts);
	}

	public classProject determineMakeorBuyBySimulation(classProject _cp) {
		return _cp;
	}
	
	public List getInhousePlanning() {
		List inhousePlannings = new ArrayList();
		int ts = Clock.getSlot();
		if (ts == timeSlotLength-1)
			inhousePlannings = inhouse.getInhousePlanning();
		return inhousePlannings;
	}

	public void outputData() {
		List customers = env.getCustomers();
		int t = Clock.getPeriod();
		int ts = Clock.getSlot();
		if (ts==timeSlotLength-1){
			for (int i=0; i<customers.size();i++){
				customerSwarm customer = (customerSwarm) customers.get(i);
				List memory = customer.memory;
				String cusName = customer.name;
				for (int j=0; j<memory.size();j++){
					DataC rc = (DataC) memory.get(j);
					String pName = rc.pName;
					String spec = rc.spec;
					int forecastedDemand= rc.o[t][ts].totalDemandInPeriod;
					DataO ro = sales.getRecordCorresponding2CustomerRecord(rc,
							cusName);
					int actualDemand = ro.ih[t][ts].customerDemandInPeriod;
					int shortage = ro.ih[t][ts].shortage;
					
					System.out.println(t+","+cusName+","+pName+","+spec+
							","+forecastedDemand+","+actualDemand+","+shortage);
					
				}
			}			
		}
	}
	
}