package organization.jade.behaviour;

import jade.core.behaviours.CyclicBehaviour;

import jade.content.*;
import jade.content.onto.basic.*;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

import organization.*;
import organization.communicationOntology.*;

public class OrderAcknowledgementReceiving extends CyclicBehaviour {
	private ContentManager manager;

	protected PhysicalAgentImpl myAgent;

	public OrderAcknowledgementReceiving(PhysicalAgentImpl a) {
		super(a);
		myAgent = a;
		this.manager = (ContentManager) a.getContentManager();
	}

	public void action() {
		OrderAcknowledgement orderAcknowledgement;
		ACLMessage msg_AGREE = this.myAgent.receive(MessageTemplate
				.MatchPerformative(ACLMessage.AGREE));
		if (msg_AGREE != null) {
			try {
				Action action = (Action) this.manager.extractContent(msg_AGREE);
				if (action.getAction() instanceof OrderAcknowledgement) {
					orderAcknowledgement = (OrderAcknowledgement) action
							.getAction();
					myAgent.receiveOrderAcknowledgement(orderAcknowledgement);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else
			block();
	}

}
