package organization.operation;

import java.util.List;

import organization.OrganizationImpl;
import organization.communicationOntology.*;
import organization.dataschema.classProject;
import organization.operation.inhouse.ManufacturingManager;
import organization.operation.process.ProcessManager;
import organization.operation.purchasing.PurchasingManager;
import organization.operation.sales.SalesManager;
import organization.operation.partners.PartnerManager;
import organization.operation.performance.PerformanceManager;
import organization.operation.database.DataManager;

public class OperationHub {

	public OrganizationImpl org;
	public ProcessManager prm;
	public PurchasingManager om;
	public ManufacturingManager mm;
	public SalesManager sm;
	public PartnerManager partners;
	public PerformanceManager performance;
	public DataManager datam;

	public OperationHub(OrganizationImpl _org) {
		this.org = _org;
		this.sm = new SalesManager(this);
		this.prm = new ProcessManager(this);
		this.partners = new PartnerManager(this);
		this.om = new PurchasingManager(this);
		this.performance = new PerformanceManager(this);
		this.mm = new ManufacturingManager(this);
		this.datam = new DataManager(this);
	}

	public void receiveInquiry(Inquiry _inquiry) {
		int op_propose = setting.PROPOSE_DIRECTLY;
		int op_OFP = setting.GET_PROCESS_DEFAULT;
		this.receiveInquiry(_inquiry, op_propose, op_OFP);
	}

	public void receiveInquiry(Inquiry _inquiry, int _op_propose) {
		int op_OFP = setting.GET_PROCESS_DEFAULT;
		this.receiveInquiry(_inquiry, _op_propose, op_OFP);
	}

	public void receiveInquiry(Inquiry _inquiry, int _op_propose, int _op_OFP) {
		this.sm.receiveInquiry(_inquiry, _op_propose, _op_OFP);
	}

	public void recieveOrder(Order _order) {
		int op_fulfill = setting.FULFILL_ORDER_DIRECTLY;
		int op_propose = setting.PROPOSE_DIRECTLY;
		this.recieveOrder(_order, op_fulfill, op_propose);
	}

	public void recieveOrder(Order _order, int _op_fulfill) {
		int op_propose = setting.PROPOSE_DIRECTLY;
		this.sm.recieveOrder(_order, _op_fulfill, op_propose);
	}

	public void recieveOrder(Order _order, int _op_fulfill, int _op_propose) {
		this.sm.recieveOrder(_order, _op_fulfill, _op_propose);
	}

	public void receiveProposal(Proposal _proposal) {
		this.om.receiveProposal(_proposal);
	}

	public void receiveCounterProposal(Proposal _counterProposal) {
		if (this.sm != null) {
			this.sm.receiveCounterProposal(_counterProposal);
		}
	}

	public void receiveGoods(GoodsDelivery _goods) {

	}

	public void receiveRefuseProposal(Proposal _proposal) {

	}

	public void receiveOrderAcknowledgement(OrderAcknowledgement _oa) {

	}

	public classProject getSimulatedOFP(List _possibleProcesses) {
		return null;
	}

	public classProject determineMakeorBuyBySimulation(classProject _cp) {
		return null;
	}

	public void deliverInquiry(Inquiry _inquiry) {
		this.org.deliverObject(_inquiry);
	}

	public void deliverProposal(Proposal _proposal) {
		this.org.deliverObject(_proposal);
	}

	public void deliverOrder(Order _order) {
		this.org.deliverObject(_order);
	}

	public void deliverCounterProposal(Proposal _counterProposal) {
		this.org.deliverObject(_counterProposal);
	}

	public void deliverGoods(GoodsDelivery _delivery) {
		this.org.deliverObject(_delivery);
	}

	public void deliverOrderAcknowledgement(OrderAcknowledgement _oa) {
		this.org.deliverObject(_oa);
	}

	public Proposal generateProposal(Proposal _proposal) {
		return this.sm.generatePreciseProposal(_proposal);
	}
	
	public void planInhouseActivities(List _inhousePlannings){
		mm.planInhouseActivities(_inhousePlannings);
	}
	
	public List getFinishedGoodsDelivery() {
		return sm.getFinishedGoodsDelivery();
	}
}
