package organization.operation.partners;

import java.util.List;

import organization.communicationOntology.Company;
import organization.operation.OperationHub;
import organization.operation.Department;

public class PartnerManager extends Department {
	private SupplierManagement sm;
	private CustomerManagement cm;

	public PartnerManager(OperationHub _ipi) {
		super(_ipi);
		sm = new SupplierManagement(this);
		cm = new CustomerManagement(this);
	}

	public Company getCompany(String _comName) {
		Company company = null;
		if (_comName == this.org.name)
			company = new Company(this.org.name, this.org.agentName);
		else {
			company = this.getSupplier(_comName);
			if (company == null)
				company = this.getCustomer(_comName);
		}
		return company;
	}

	public Company getSupplier(String _comName) {
		return this.sm.getSupplier(_comName);
	}

	public Company getCustomer(String _comName) {
		return this.cm.getCustomer(_comName);
	}

	public List getSuppliers() {
		return this.sm.getAllSuppliers();
	}

	public List getCustomers() {
		return this.cm.getAllCustomers();
	}

}
