package organization;
import java.rmi.*;

public class RMICheck implements Remote {
	private String url;
	
	public RMICheck() {
		
	}
	
	public RMICheck(String _host, int _port) {
		this.url = "rmi://" + _host + ":" + _port + "/";
	}
	
	public boolean isRMIawake () {
		try {
			Naming.bind(url, new RMICheck());			
			Naming.unbind(url);
		}catch(MarshalException exe) {
				//RMI was found
			}
		 catch(Exception e) {
			return false; 
		} 		
		return true;
	}
	
	public static void main(String args[]) {
		RMICheck rmi = new RMICheck("localhost", 8991);
		System.out.println(rmi.isRMIawake());
	}
}
