package organization.jade.behaviour;

import jade.core.behaviours.CyclicBehaviour;
import jade.content.*;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

import jade.content.onto.basic.*;

import organization.*;
import organization.communicationOntology.*;

public class InformReceiving  extends CyclicBehaviour {
  private ContentManager manager;

  protected PhysicalAgentImpl myAgent;

  public InformReceiving (PhysicalAgentImpl a) {
    super(a);
    this.myAgent = a;
    this.manager  = (ContentManager) a.getContentManager();
  }

  public void action() {
	Time time;
	GoodsDelivery delivery;
    ACLMessage msg = this.myAgent.receive(MessageTemplate.MatchPerformative(ACLMessage.INFORM));
    if (msg != null) {
      try {
        Action action = (Action) manager.extractContent(msg);
        if (action.getAction() instanceof Time) {
            time = (Time) action.getAction();
            myAgent.updateTime(time);
        }
        else if (action.getAction() instanceof GoodsDelivery) {
            delivery = (GoodsDelivery) action.getAction();
            myAgent.receiveGoods(delivery);       	
        }
       }
      catch(Exception e) {
              e.printStackTrace();
      }
    }
    else {
      block();
    }
  }
}
