import java.io.*;
import java.util.List;
import java.util.ArrayList;

import organization.NormDist;

public class ConsumersDemandGenerator {
	int mean[]; 
	double[][] coeff;
	double[] var;
    private int timePeriods;
    public int[][] demand;

    public ConsumersDemandGenerator() {
    	parseMarketFeatures();
    	demand = getARDemand();
    }
    
    private void writeDemand2File() {
    	try {
        	FileWriter fwriter = new FileWriter("demand.txt"); 
    		for (int t=1; t<demand.length; t++){
    	    	for (int i=0;i<demand[0].length;i++){
    	        	fwriter.write(String.valueOf(demand[t][i]));
    	        	fwriter.write(new String(" "));
    	    	}
    	    	fwriter.write(new String("\r\n"));
    		}
        fwriter.close(); 
    	}
    	catch (IOException e) {
    	}   	
    }
        
    private int[][] getARDemand() {
    	int[][] demand = new int[timePeriods][mean.length];
    	double[] result = new double[mean.length];
    	
    	NormDist[] ndist = new NormDist[mean.length];
    	
		for (int i=0; i<mean.length;i++){
			ndist[i] = new NormDist(0, var[i]);
			demand[0][i]= mean[i];
		}
		
		for (int t=1; t<timePeriods; t++){
	    	for (int i=0;i<coeff.length;i++){
	    		result[i]= mean[i];
	    		for (int j=0; j<coeff[0].length;j++)
	    			result[i] += coeff[i][j]* demand[t-1][j];
	    		result[i] += ndist[i].inverseCdf(Math.random());
	    		demand[t][i]= (int) result[i];
	    		if (demand[t][i]<0) demand[t][i]=0;
	    	}			
		}
    	return demand;
    }
    
    private void parseMarketFeatures(){
    	try {
    		FileReader fr = new FileReader("marketFeatures.txt");
    		BufferedReader br = new BufferedReader(fr);
    		int j, k, count=-1;
    		String str;
    		List elem;
    		int att=0, oldatt=0;
    		while ((str = br.readLine()) != null) {
    			str = str.trim();
        		if (str.equals("//mean"))
        			att = 1;
        		else if (str.equals("//coeff"))
        			att = 2;
        		else if (str.equals("//variance"))
        			att = 3;
        		else if (str.equals("//length of time period"))
        			att = 4;
    			if (oldatt!=att) str = br.readLine();

    			if (str != null) {
    				elem = new ArrayList();
    				k=0;
        			while ( (j = str.indexOf(" ", k)) != -1) {
            			elem.add(str.substring(k, j));
            			k=j+1;
        			}
        			elem.add(str.substring(k, str.length()));
        			if (att==1) {
        				this.mean = new int[elem.size()];
        				this.coeff = new double[elem.size()][elem.size()];
        				this.var = new double[elem.size()];
        			}
        			for (int i=0;i<elem.size();i++) {
        				if (att==1) 
        					this.mean[i]= Integer.parseInt((String) elem.get(i));
        				if (att==2) {
        					if (i==0)count++;
        					this.coeff[count][i]= Double.parseDouble((String) elem.get(i));        					
        				}
        				if (att==3) 
        					this.var[i]= Double.parseDouble((String) elem.get(i));
        				if (att==4) 
        					this.timePeriods = Integer.parseInt((String) elem.get(i));
        			}
        			
    			}
    			oldatt=att;
    			
    		}
    	}
    	catch (IOException e) {
    	}   	
    }

	public static void main(String args[]) {
		ConsumersDemandGenerator sc = new ConsumersDemandGenerator();
    	sc.writeDemand2File();
	}
}