package organization;

import organization.communicationOntology.*;
import organization.jade.behaviour.*;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.core.*;

import organization.dataschema.Clock;

public class PhysicalAgentImpl extends Agent {
	private Codec codec = new SLCodec();
	private Ontology ontology = CommunicationOntology.getInstance();
	ConsumersImpl market;
		
	protected void setup() {		
		setEnabledO2ACommunication(true, 5);
		Object[] obj = getArguments();
		this.market = (ConsumersImpl) obj[0];

		this.getContentManager().registerOntology(ontology);
		this.getContentManager().registerLanguage(codec);
		
		addBehaviour(new OrderListening(this));
		addBehaviour(new InformReceiving(this));
	}	 
	
	public void takeDown() {
//		 Disables the object-to-agent communication channel, thus
//		 waking up all waiting threads
		setEnabledO2ACommunication(false, 0);
	}

//deliveringBehaviour	  
	public void deliverOrder(Order _order) {
	    addBehaviour(new OrderDelivering(this, _order));		  
	}
	
	  
//receivingBehaviour	  
	public void receiveGoods(GoodsDelivery _delivery) {
		market.receiveDelivery(_delivery);
	}
	
	public void updateTime(Time _time) {
		Clock.period = _time.getPeriod();
		Clock.slot = _time.getSlot();
		market.deliverMarketDemand();
	}
	
}



