/**
 * 
 */
package organization.communicationOntology;

import jade.content.onto.*;

import java.io.*;

import jade.content.schema.*;

public class CommunicationOntology extends Ontology implements Serializable {

	  public static final String ONTOLOGY_NAME = "Communication-Ontology";

	  public static final String ACTIVITY = "ACTIVITY";
	  public static final String ACTIVITY_NAME = "name";
	  public static final String ACTIVITY_SPEC = "spec";
	  public static final String ACTIVITY_QUANTITY = "quantity";

	  public static final String COMPANY = "COMPANY";
	  public static final String COMPANY_NAME = "name";
	  public static final String COMPANY_AGENTNAME = "agentName";
	  
	  public static final String DETAILED_DELIVERY_PLAN = "DETAILED-DELIVERY-PLAN";
	  public static final String DETAILED_DELIVERY_PLAN_PROMISED_DATETIME = "promisedDatetime";
	  public static final String DETAILED_DELIVERY_PLAN_PROMISED_DELIVER_QUANTITY = "promisedDeliverQuantity";
	  	  
	  public static final String COMPLETE_DELIVERY_PLAN = "COMPLETE-DELIVERY-PLAN";
	  public static final String COMPLETE_DELIVERY_PLAN_DETAILED_DELIVERY_PLAN = "detailedDeliveryPlan";
	  public static final String COMPLETE_DELIVERY_PLAN_TOTAL_QUANTITY = "totalQuantity";
	  public static final String COMPLETE_DELIVERY_PLAN_PRICE = "price";

	  public static final String TIME = "TIME";
	  public static final String TIME_PERIOD = "period";
	  public static final String TIME_SLOT = "slot";
	  	  
	  // Actions
	  public static final String INQUIRY = "INQUIRY";
	  public static final String INQUIRY_INQ_NO = "inqNo";
	  public static final String INQUIRY_RECEIVER = "receiver";
	  public static final String INQUIRY_SENDER = "sender";
	  public static final String INQUIRY_ACTIVITY = "activity";
	  public static final String INQUIRY_DATETIME = "inquiryDatetime";
	  public static final String INQUIRY_REQUIRED_DATETIME = "requiredDatetime";
	  public static final String INQUIRY_QUALITY_LEVEL = "qualityLevel";

	  public static final String PROPOSAL = "PROPOSAL";
	  public static final String PROPOSAL_INQUIRY = "inquiry";
	  public static final String PROPOSAL_DATETIME = "datetime";
	  public static final String PROPOSAL_DELIVERY_PLAN = "deliveryPlan";
	  public static final String PROPOSAL_COUNTER = "counter";
	  public static final String PROPOSAL_QUALITY_LEVEL = "qualityLevel";
	  
	  public static final String ORDER = "ORDER";
	  public static final String ORDER_INQUIRY = "inquiry";
	  public static final String ORDER_ORDER_PLACING_DATETIME = "orderPlacingDatetime";
	  public static final String ORDER_AGREED_PROPOSAL = "agreedProposal";
	  public static final String ORDER_QUALITY_LEVEL = "qualityLevel";
	  
	  public static final String ORDER_ACKNOWLEDGEMENT = "ORDER-ACKNOWLEDGEMENT";
	  public static final String ORDER_ACKNOWLEDGEMENT_ORDER = "order";
	  public static final String ORDER_ACKNOWLEDGEMENT_ORDER_RECEIVING_DATETIME = "orderReceivingDatetime";

	  public static final String GOODS_DELIVERY = "GOODS-DELIVERY";
	  public static final String GOODS_DELIVERY_ORDER = "order";
	  public static final String GOODS_DELIVERY_DETAILED_DELIVERY = "detailedDelivery";
	  public static final String GOODS_DELIVERY_DELIVER_QUANTITY = "deliverQuantity";
	  public static final String GOODS_DELIVERY_DELIVER_DATETIME = "deliverDatetime";

	  private static Ontology theInstance = new CommunicationOntology();

	  public static Ontology getInstance() {
	    return theInstance;
	  }

	  public CommunicationOntology() {
		    super(ONTOLOGY_NAME, BasicOntology.getInstance());
		    try {
		      add(new ConceptSchema(ACTIVITY), Activity.class);
		      add(new ConceptSchema(COMPANY), Company.class);
		      add(new ConceptSchema(DETAILED_DELIVERY_PLAN), DetailedDeliveryPlan.class);
		      add(new ConceptSchema(COMPLETE_DELIVERY_PLAN), CompleteDeliveryPlan.class);
		      add(new ConceptSchema(TIME), Time.class);
		      add(new ConceptSchema(INQUIRY), Inquiry.class);
		      add(new ConceptSchema(PROPOSAL), Proposal.class);
		      add(new ConceptSchema(ORDER), Order.class);
		      add(new ConceptSchema(ORDER_ACKNOWLEDGEMENT), OrderAcknowledgement.class);
		      add(new ConceptSchema(GOODS_DELIVERY), GoodsDelivery.class);

		      ConceptSchema cs = (ConceptSchema) getSchema(ACTIVITY);
		      cs.add(ACTIVITY_NAME, (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      cs.add(ACTIVITY_SPEC, (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      cs.add(ACTIVITY_QUANTITY,
		             (PrimitiveSchema) getSchema(BasicOntology.INTEGER));

		      cs = (ConceptSchema) getSchema(COMPANY);
		      cs.add(COMPANY_NAME, (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      cs.add(COMPANY_AGENTNAME, (PrimitiveSchema) getSchema(BasicOntology.STRING));

		      cs = (ConceptSchema) getSchema(DETAILED_DELIVERY_PLAN);
		      cs.add(DETAILED_DELIVERY_PLAN_PROMISED_DATETIME, (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      cs.add(DETAILED_DELIVERY_PLAN_PROMISED_DELIVER_QUANTITY, (PrimitiveSchema) getSchema(BasicOntology.INTEGER));

		      cs = (ConceptSchema) getSchema(COMPLETE_DELIVERY_PLAN);
		      cs.add(COMPLETE_DELIVERY_PLAN_DETAILED_DELIVERY_PLAN, (ConceptSchema) getSchema(DETAILED_DELIVERY_PLAN),
		    		  1, ObjectSchema.UNLIMITED);
		      cs.add(COMPLETE_DELIVERY_PLAN_TOTAL_QUANTITY, (PrimitiveSchema) getSchema(BasicOntology.INTEGER));
		      cs.add(COMPLETE_DELIVERY_PLAN_PRICE, (PrimitiveSchema) getSchema(BasicOntology.INTEGER));

		      ConceptSchema as = (ConceptSchema) getSchema(INQUIRY);
		      as.add(INQUIRY_INQ_NO, (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      as.add(INQUIRY_RECEIVER, (ConceptSchema) getSchema(COMPANY));
		      as.add(INQUIRY_SENDER, (ConceptSchema) getSchema(COMPANY));
		      as.add(INQUIRY_ACTIVITY, (ConceptSchema) getSchema(ACTIVITY));
		      as.add(INQUIRY_DATETIME, (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      as.add(INQUIRY_REQUIRED_DATETIME, (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      as.add(INQUIRY_QUALITY_LEVEL, (PrimitiveSchema) getSchema(BasicOntology.FLOAT));

		      cs = (ConceptSchema) getSchema(TIME);
		      cs.add(TIME_PERIOD, (PrimitiveSchema) getSchema(BasicOntology.INTEGER));
		      cs.add(TIME_SLOT, (PrimitiveSchema) getSchema(BasicOntology.INTEGER));

		      as = (ConceptSchema) getSchema(PROPOSAL);
		      as.add(PROPOSAL_INQUIRY, (ConceptSchema) getSchema(INQUIRY));
		      as.add(PROPOSAL_DATETIME,
		             (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      as.add(PROPOSAL_DELIVERY_PLAN, (ConceptSchema) getSchema(COMPLETE_DELIVERY_PLAN));
		      as.add(PROPOSAL_COUNTER, (ConceptSchema) getSchema(COMPLETE_DELIVERY_PLAN));
		      as.add(PROPOSAL_QUALITY_LEVEL, (PrimitiveSchema) getSchema(BasicOntology.FLOAT));
			  
		      as = (ConceptSchema) getSchema(ORDER);
		      as.add(ORDER_INQUIRY, (ConceptSchema) getSchema(INQUIRY));
		      as.add(ORDER_ORDER_PLACING_DATETIME,
		             (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      as.add(ORDER_AGREED_PROPOSAL, (ConceptSchema) getSchema(COMPLETE_DELIVERY_PLAN));
		      as.add(ORDER_QUALITY_LEVEL, (PrimitiveSchema) getSchema(BasicOntology.FLOAT));

		      as = (ConceptSchema) getSchema(ORDER_ACKNOWLEDGEMENT);
		      as.add(ORDER_ACKNOWLEDGEMENT_ORDER, (ConceptSchema) getSchema(ORDER));
		      as.add(ORDER_ACKNOWLEDGEMENT_ORDER_RECEIVING_DATETIME,
		             (PrimitiveSchema) getSchema(BasicOntology.STRING));
		      
		      as = (ConceptSchema) getSchema(GOODS_DELIVERY);
		      as.add(GOODS_DELIVERY_ORDER, (ConceptSchema) getSchema(ORDER));
		      as.add(GOODS_DELIVERY_DETAILED_DELIVERY, (ConceptSchema) getSchema(DETAILED_DELIVERY_PLAN));
		      as.add(GOODS_DELIVERY_DELIVER_QUANTITY, (PrimitiveSchema) getSchema(BasicOntology.INTEGER));
		      as.add(GOODS_DELIVERY_DELIVER_DATETIME,
		             (PrimitiveSchema) getSchema(BasicOntology.STRING));
		    }
		    catch (OntologyException oe) {
		      oe.printStackTrace();
		    }
	}

	  public static void main(String args[]) {
		    Ontology ontology = CommunicationOntology.getInstance();
		    System.out.println(ontology.getName());
		  }


}
