package organization.dataschema;

public class Clock {
	
	public static int period;
	public static int slot;
	public static int numberOfTimeslots; 
	
	
	public void updateTime(int _period, int _slot) {
		period = _period;
		slot= _slot;
	}
	
	public static void advanveOneSlot() {
		slot++;
		if (slot==numberOfTimeslots){
			period++;
			slot=0;
		}
	}
	
	public static String getTime() {
		return gen4digitSeqNo(period)+"/"+gen4digitSeqNo(slot); 
	}
	
	
	public static String getTime(int _period, int _slot) {
		return gen4digitSeqNo(_period)+"/"+gen4digitSeqNo(_slot); 
	}
	
	
	public static String gen4digitSeqNo(int _num) {
		String sub_seq = "000" + _num;
		int sub_seq_len = sub_seq.length();
		sub_seq = sub_seq.substring(sub_seq_len-4, sub_seq_len);
		return sub_seq;
	}
	
	public static String computeTime(String _time, int _addedPeriods,
			int _addedSlots){
		int period = getPeriod(_time) + _addedPeriods;
		int slot = getPeriod(_time) + _addedSlots;
		
		while (slot>=numberOfTimeslots){
			period++;
			slot -= numberOfTimeslots;
		}
		while (slot<0){
			period--;
			slot += numberOfTimeslots;
			
		}
		return getTime(period, slot);
	}
	
	public static int getPeriod(String _time){
		return Integer.parseInt(_time.substring(0,4));
	}
	
	public static int getSlot(String _time){
		return Integer.parseInt(_time.substring(5,9));
	}
	
	public static int getPeriod(){
		return period;
	}

	public static int getSlot(){
		return slot;
	}

	public static int getTimeDif (String _begin, String _end) {
		if (_begin!=null&_end!=null) {
			int periodDifference = getPeriod(_end)-getPeriod(_begin);
			int slotDifference = getPeriod(_end)-getPeriod(_begin);
			return (periodDifference*numberOfTimeslots+slotDifference+1);
		}
		return 0;
	}
	
	public static String getTime (String _begin, int _addedTimeslots) {
		int periods = _addedTimeslots / numberOfTimeslots;
		int slots = _addedTimeslots % numberOfTimeslots;
		int newPeriod = getPeriod(_begin)+periods;
		int newSlot = getPeriod(_begin)+slots;
		if (newSlot>=numberOfTimeslots) {
			newPeriod++;
			newSlot -=numberOfTimeslots;
		}
		if (newSlot<0){
			newPeriod--;
			newSlot +=numberOfTimeslots;
		}
		return gen4digitSeqNo(newPeriod)+"/"+gen4digitSeqNo(newSlot);
	}
	
	public static String getFormerTime(String _dt1, String _dt2) {
		String formerTime = _dt1;
		int diff = getTimeDif (_dt1, _dt2);
		if (diff<0) formerTime = _dt2; 
		return formerTime;
	}
	
	
	
	public static void main(String[] args) {
		Clock.numberOfTimeslots = 8;
		System.out.println(getTimeDif("0010/0008", "0011/0003"));
	}

}
