package organization;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import organization.communicationOntology.Activity;
import organization.communicationOntology.Company;
import organization.communicationOntology.CompleteDeliveryPlan;
import organization.communicationOntology.GoodsDelivery;
import organization.communicationOntology.Inquiry;
import organization.communicationOntology.Order;
import organization.dataschema.Clock;

public class ConsumersImpl {
	public Clock time;
	public String orgName;
	public String agentName;
	
	private int periodLimit;
	
	protected JadeAgentContainerInitiator JACI;
	protected int[][] marketDemand;
	
	public ConsumersImpl(String _orgName, String _agentName,
			String _fileName) {
		this.orgName = _orgName;
		this.agentName = _agentName;
		List demandInSlot, demandInTimePeriod;
		demandInTimePeriod = new ArrayList();
		demandInSlot = new ArrayList();
    	try {
    		FileReader fr = new FileReader(_fileName);
    		BufferedReader br = new BufferedReader(fr);
    		int j, k;
    		String str;
    		while ((str = br.readLine()) != null) {
    			str = str.trim();
				demandInSlot = new ArrayList();
				k=0;
    			while ( (j = str.indexOf(" ", k)) != -1) {
    				demandInSlot.add(str.substring(k, j));
        			k=j+1;
    			}
    			demandInSlot.add(str.substring(k, str.length()));
    			demandInTimePeriod.add(demandInSlot);
    		}
    		Clock.numberOfTimeslots=demandInSlot.size();
    		marketDemand =  new int[demandInTimePeriod.size()][demandInSlot.size()];
    	}
    	catch (IOException e) {
    	}   	
    	periodLimit = demandInTimePeriod.size();
		for (int i=0; i<demandInTimePeriod.size(); i++){
			demandInSlot = (List) demandInTimePeriod.get(i);
			for (int j=0; j<demandInSlot.size();j++)
				marketDemand[i][j]=
					Integer.parseInt((String) demandInSlot.get(j));
		}
	}

	public void deliverMarketDemand() {
		Clock.advanveOneSlot();
		int t =  Clock.getPeriod();
		int slot =  Clock.getSlot();
		if (t<=periodLimit){
			int quantity=marketDemand[t][slot];
			System.out.println(t+","+slot+","+quantity);
//	inquiry
			String inqNo = t + "." + slot;
			Company receiver = new Company ("distributors", "D");
			Company sender =  new Company ("consumers", "C");
			Activity activity = new Activity("DSC NSC3000","NSC3000",quantity);
			String inquiryDatetime = Clock.getTime();
			String requiredDatetime=""; //reserved for future use
			float qualityLevel = 0; //reserved for future use

			Inquiry inq = new Inquiry(inqNo, receiver, sender, activity,
						  inquiryDatetime, requiredDatetime, qualityLevel);

			String orderPlacingDatetime= Clock.getTime();

//	CompleteDeliveryPlan
			String datetime="";  //reserved for future use
			int price=0;         //reserved for future use
			CompleteDeliveryPlan agreedProposal = new CompleteDeliveryPlan(datetime, quantity, price);

			Order order = new Order(inq, orderPlacingDatetime, agreedProposal, qualityLevel); 
			this.deliverOrder(order);		
		}
		else {
			System.out.println("run out of demand");
		}
	}
	
	private void deliverOrder(Order _order){
		this.JACI.deliverOrder(_order);
	}
	
	public void setJadeEnvironment(String _host, int _port, 
			boolean _newPlatform, String _containerName,
			String _agentClassName) {
		try {
			if (_newPlatform)
			Runtime.getRuntime().exec("java jade.Boot -gui -port " + _port);
		} catch(Exception e) {
			System.out.println(e);
		}
		RMICheck rmi = new RMICheck(_host, _port);
		do {} while (!rmi.isRMIawake());

//initialize a new agent container in Jade platform		
		this.JACI = 
			new JadeAgentContainerInitiator(_host, _port, _containerName, this);
		
		JACI.registerAgent(agentName, _agentClassName);
				
//sniffer		
		JACI.snifferingAllAgents();

	}
	
	public void destroyJadeEnvironment() {
		JACI.destoryAgentContainer();
	}
	
	
// reserved function	
	public void receiveDelivery(GoodsDelivery _delivery) {
		int receivedDelivery = _delivery.getDeliverQuantity();
	}

	
}
