package organization.jade.behaviour;

import jade.lang.acl.ACLMessage;

import jade.core.*;
import jade.core.behaviours.OneShotBehaviour;

import jade.content.lang.Codec;
import jade.content.lang.sl.*;
import jade.content.onto.*;
import jade.content.onto.basic.*;
import organization.PhysicalAgentImpl;
import organization.communicationOntology.*;

public class OrderDelivering extends OneShotBehaviour {
	  private Codec codec = new SLCodec();
	  private Ontology ontology = CommunicationOntology.getInstance();

	  protected PhysicalAgentImpl myAgent;
	  protected Order order;

	  public OrderDelivering(PhysicalAgentImpl a, Order _order){
		    super(a);
		    myAgent =  a;
		    this.order = _order;
	   }

	   public void action(){
			 Company receiver = this.order.getInquiry().getReceiver();   
 			 AID receiverAgent = new AID(receiver.getAgentName(), AID.ISLOCALNAME);		    
		     Action action = new Action();
		     action.setActor(receiverAgent);
		     action.setAction(order);
		     ACLMessage orderMsg = new ACLMessage(ACLMessage.INFORM);
		     orderMsg.addReceiver(receiverAgent);
		     orderMsg.setLanguage(codec.getName());
		     orderMsg.setOntology(ontology.getName());
		     try {
		         myAgent.getContentManager().fillContent(orderMsg, action);
				 System.out.println(order.getOrderPlacingDatetime());
				 myAgent.send(orderMsg);
		     } catch (Exception pe) {
		         System.out.println(pe.getMessage());
		     }
		     myAgent.addBehaviour(new TimeMsgAckDelivering(myAgent));
		     
		   }

}
