package organization;

import jade.core.Runtime;
import jade.core.Profile;
import jade.core.ProfileImpl;

import jade.wrapper.*;

import organization.communicationOntology.*;

public class JadeAgentContainerInitiator {
  private Runtime rt;
  private Profile pMain;

  private AgentContainer ac;
  private AgentController sniffer;
  
  private ConsumersImpl market;
  
  public JadeAgentContainerInitiator(String _hostName, int _port, 
		  String _containerName, ConsumersImpl _market) {
	  this.market = _market;
	  try {
	      this.rt = Runtime.instance();
	      this.rt.setCloseVM(true);
	      this.pMain = new ProfileImpl(_hostName, _port, null);
	      this.pMain.setParameter(Profile.CONTAINER_NAME, _containerName);
	      this.ac = (AgentContainer) rt.createAgentContainer(pMain);
	  }
	  catch(Exception e) {
	      e.printStackTrace();
	  }
  }
  
  public void registerAgent(String _agentName, String _agentClassName) {
	  Object[] obj = {this.market};
	  try {
		  AgentController agent = 
			  ac.createNewAgent(_agentName, _agentClassName, obj);
		  agent.start();
	  }
	  catch(Exception e) {
	      e.printStackTrace();
	  }
  }
  
  public void snifferingAllAgents() {
	  try {
	      this.sniffer = ac.createNewAgent("sniffer", "jade.tools.sniffer.Sniffer", new Object[0]);
	      this.sniffer.start();
	  }
	  catch(Exception e) {
	      e.printStackTrace();
	  }
  }
  
  public void deliverOrder(Order _order) {
	  Object[] obj = {_order};
	  String agentName = market.agentName;
	    try {
	    	AgentController agent = ac.getAgent(agentName);
// false means asynchronous is allowed
	    	agent.putO2AObject(obj, false);
	    }
	    catch(Exception e) {
	        e.printStackTrace();
	    }	    
  }
  
  public void destoryAgentContainer() {
	  try {
		  System.out.println(this.ac.getPlatformName());
		  this.ac.kill();
	    }
	    catch(Exception e) {
	        e.printStackTrace();
	    }	    
  }
}