package organization;

import organization.communicationOntology.*;
import organization.jade.behaviour.*;
import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.core.*;

public class PhysicalAgentImpl extends Agent {
	private Codec codec = new SLCodec();

	private Ontology ontology = CommunicationOntology.getInstance();

	public OrganizationImpl org;

	protected void setup() {
		setEnabledO2ACommunication(true, 5);
		Object[] obj = getArguments();
		this.org = (OrganizationImpl) obj[0];

		this.getContentManager().registerOntology(ontology);
		this.getContentManager().registerLanguage(codec);

		addBehaviour(new InquiryReceiving(this));
		addBehaviour(new ProposalReceiving(this));

		addBehaviour(new OrderAcknowledgementReceiving(this));
		addBehaviour(new InformReceiving(this));
		addBehaviour(new ObjectListening(this));

	}

//deliveringBehaviour
	public void deliverInquiry(Inquiry _inquiry) {
		addBehaviour(new InquiryDelivering(this, _inquiry));
	}

	public void deliverProposal(Proposal _proposal) {
		addBehaviour(new ProposalDelivering(this, _proposal));
	}

	public void deliverOrder(Order _order) {
		addBehaviour(new OrderDelivering(this, _order));
	}

	public void deliverGoods(GoodsDelivery _delivery) {
		addBehaviour(new GoodsDelivering(this, _delivery));
	}

	public void deliverCounterProposal(Proposal _counterProposal) {
		addBehaviour(new CounterProposalDelivering(this, _counterProposal));
	}

	public void deliverOrderAcknowledgement(OrderAcknowledgement _oa) {
		addBehaviour(new OrderAcknowledgementDelivering(this, _oa));
	}

//receivingBehaviour
	public void receiveInquiry(Inquiry _inquiry) {
		this.org.receiveInquiry(_inquiry);
	}

	public void receiveProposal(Proposal _proposal) {
		this.org.receiveProposal(_proposal);
	}

	public void receiveOrder(Order _order) {
		this.org.receiveOrder(_order);
	}

	public void receiveGoods(GoodsDelivery _delivery) {
		this.org.receiveDelivery(_delivery);
	}

	public void receiveCounterProposal(Proposal _proposal) {
		this.org.receiveCounterProposal(_proposal);
	}

	public void receiveRefusePropoasl(Proposal _proposal) {
		this.org.receiveRefuseProposal(_proposal);
	}

	public void receiveOrderAcknowledgement(OrderAcknowledgement _oa) {
		this.org.receiveOrderAcknowledgement(_oa);
	}

	public void updateTime(Time _time) {
		this.org.updateTime(_time);
	}

	public void takeDown() {
		//Disables the object-to-agent communication channel, thus
		//waking up all waiting threads
		setEnabledO2ACommunication(false, 0);
	}
}
