package organization.beliefSystem.dataschema;

import organization.communicationOntology.Order;
import organization.dataschema.Clock;


public class DataC {
	public String pName;
	public String spec;
	public double constantFunction;

	public ForecastRecord[][] f;
	public OutsourceRecord[][] o;
	
	public DataC(String _pName, String _spec, double _constantFunction, 
			int _tLength, int _sLength) {
		pName = _pName;
		spec = _spec;
		constantFunction = _constantFunction;
		initializeDataArray(_tLength, _sLength);
	}

	private void initializeDataArray(int _tLength, int _sLength) {
		f = new ForecastRecord[_tLength][_sLength];
		for (int i = 0; i < _tLength; i++)
			for (int j = 0; j < _sLength; j++)
				f[i][j] = new ForecastRecord();
		o = new OutsourceRecord[_tLength][_sLength];
		for (int i = 0; i < _tLength; i++)
			for (int j = 0; j < _sLength; j++)
				o[i][j] = new OutsourceRecord();
	}

	public void recordDemand(Order _order) {
		int quantity = _order.getInquiry().getActivity().getQuantity();
		String orderPlacingTime = _order.getOrderPlacingDatetime();
		int t = Clock.getPeriod(orderPlacingTime);
		int ts = Clock.getSlot(orderPlacingTime);
		o[t][ts].actualDemandInSlot = quantity;
		o[t][o[t].length - 1].totalDemandInPeriod += quantity;
	}

}
