package organization.jade.behaviour;

import jade.core.*;
import jade.core.behaviours.OneShotBehaviour;

import jade.content.lang.Codec;
import jade.content.onto.*;
import jade.content.lang.sl.*;
import jade.content.onto.basic.*;

import jade.lang.acl.ACLMessage;

import organization.*;
import organization.communicationOntology.*;

public class CounterProposalDelivering extends OneShotBehaviour {

	private Codec codec = new SLCodec();

	private Ontology ontology = CommunicationOntology.getInstance();

	private PhysicalAgentImpl myAgent;

	private Proposal counterProposal;

	public CounterProposalDelivering(PhysicalAgentImpl a,
			Proposal _counterProposal) {
		super(a);
		this.counterProposal = _counterProposal;
	}

	public void action() {
		Company receiver;
		ACLMessage proposeMsg;
		receiver = this.counterProposal.getInquiry().getReceiver();
		AID receiverAgent = new AID(receiver.getAgentName(), AID.ISLOCALNAME);
		Action action = new Action();
		action.setActor(receiverAgent);

		proposeMsg = new ACLMessage(ACLMessage.PROPOSE);

		proposeMsg.addReceiver(receiverAgent);
		proposeMsg.setLanguage(codec.getName());
		proposeMsg.setOntology(ontology.getName());

		try {
			this.myAgent.getContentManager().fillContent(proposeMsg, action);
			this.myAgent.send(proposeMsg);
		} catch (Exception pe) {
			System.out.println(pe.getMessage());
		}
	}

}
