package organization;

import jade.core.Runtime;
import jade.core.Profile;
import jade.core.ProfileImpl;

import jade.wrapper.*;

public class JadeAgentContainerInitiator {
	private Runtime rt;

	private Profile pMain;

	private AgentContainer ac;

	private AgentController sniffer;

	private OrganizationImpl organization;

	public JadeAgentContainerInitiator(String _hostName, int _port,
			String _containerName, OrganizationImpl _organization) {
		this.organization = _organization;
		try {
			this.rt = Runtime.instance();
			this.rt.setCloseVM(true);
			this.pMain = new ProfileImpl(_hostName, _port, null);
			this.pMain.setParameter(Profile.CONTAINER_NAME, _containerName);
			this.ac = (AgentContainer) rt.createAgentContainer(pMain);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void registerAgent(String _agentName, String _agentClassName) {
		Object[] obj = { this.organization };
		try {
			AgentController agent = ac.createNewAgent(_agentName,
					_agentClassName, obj);
			agent.start();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void snifferingAllAgents() {
		try {
			this.sniffer = ac.createNewAgent("sniffer",
					"jade.tools.sniffer.Sniffer", new Object[0]);
			this.sniffer.start();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void deliverObject(Object _obj) {
		Object[] obj = {_obj};
		String agentName = this.organization.agentName;
		try {
			AgentController agent = ac.getAgent(agentName);
			agent.putO2AObject(obj, false);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void destoryAgentContainer() {
		try {
			this.ac.kill();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}