package organization.jade.behaviour;

import jade.lang.acl.ACLMessage;

import jade.core.*;
import jade.core.behaviours.OneShotBehaviour;

import jade.content.lang.Codec;
import jade.content.lang.sl.*;

import jade.content.onto.*;
import jade.content.onto.basic.*;

import organization.*;
import organization.communicationOntology.*;


public class GoodsDelivering extends OneShotBehaviour {
	private Codec codec = new SLCodec();
	private Ontology ontology = CommunicationOntology.getInstance();

	protected GoodsDelivery delivery;

	protected PhysicalAgentImpl myAgent;

	public GoodsDelivering(PhysicalAgentImpl a, GoodsDelivery _delivery) {
		super(a);
		this.delivery = _delivery;
		this.myAgent = a;
	}

	public void action() {
		Company receiver = this.delivery.getOrder().getInquiry().getSender();
		AID receiverAgent = new AID(receiver.getAgentName(), AID.ISLOCALNAME);
		Action action = new Action();
		action.setActor(receiverAgent);
		action.setAction(this.delivery);
		ACLMessage requestMsg = new ACLMessage(ACLMessage.INFORM);
		requestMsg.addReceiver(receiverAgent);
		requestMsg.setLanguage(codec.getName());
		requestMsg.setOntology(ontology.getName());
		try {
			this.myAgent.getContentManager().fillContent(requestMsg, action);
			this.myAgent.send(requestMsg);
		} catch (Exception pe) {
			System.out.println(pe.getMessage());
		}
	}
}
