package organization.operation;

import java.io.File;

import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.apache.xpath.XPathAPI;

import java.util.List;
import java.util.ArrayList;

import organization.dataschema.*;

public class OrganizationProfile {

	private String XML_FILE_NAME;

	public String name;

	public String agentName;

	public int forecastingMethod;

	public String JadePlatformHost;

	public int JadePlatformPort;

	public String JadePlatformContainer;

	private Document doc;

	public List product;
	public List productionLine;
	public List workflow;
	public List customers;
	public List suppliers;
	public List inhouseActivities;

	public OrganizationProfile(String _name) {
		this.XML_FILE_NAME = _name + ".profile.xml";

		this.doc = parseXmlFile(this.XML_FILE_NAME);
		this.setBasicData();

		product = new ArrayList();
		productionLine = new ArrayList();
		workflow = new ArrayList();
		customers = new ArrayList();
		suppliers = new ArrayList();
		inhouseActivities = new ArrayList();

		this.setProductionLines();
		this.setWorkflows();
		this.setProduct();
		this.setInhouseActivities();
		this.setCustomers();
		this.setSuppliers();
	}

	private void setBasicData() {
		this.name = (String) extractValue("//Company", "name").get(0);

		this.agentName = (String) extractValue("//Company/AgentName", null)
				.get(0);
		JadePlatformHost = (String) extractValue("//Company/JadePlatformHost",
				null).get(0);
		JadePlatformPort = Integer.parseInt((String) extractValue(
				"//Company/JadePlatformPort", null).get(0));
		JadePlatformContainer = (String) extractValue(
				"//Company/JadePlatformContainer", null).get(0);
		forecastingMethod = Integer.parseInt((String) extractValue(
				"//Company/ForecastingMethod", null).get(0));
	}

	private void setProduct() {
		List products = extractValue("//Company/Product", "name");
		for (int i = 0; i < products.size(); i++) {
			String pname = (String) products.get(i);
			String spec = (String) extractValue(
					"//Company/Product[@name='" + pname + "']/Spec", null).get(
					0);
			spec = (spec != null) ? spec : null;
			String workflowName = (String) extractValue(
					"//Company/Product[@name='" + pname + "']/Workflow", null)
					.get(0);

			String startActivityName = (String) extractValue(
					"//Company/Workflow[@name='" + workflowName
							+ "']/StartActivity", null).get(0);
			String endActivityName = (String) extractValue(
					"//Company/Workflow[@name='" + workflowName
							+ "']/EndActivity", null).get(0);
			classProduct cp = new classProduct(this.name, pname, spec,
					workflowName, startActivityName, endActivityName);
			product.add(cp);

		}
	}

	private void setProductionLines() {
		List products = extractValue("//Company/ProductionLine", "name");
		for (int i = 0; i < products.size(); i++) {
			String name = (String) products.get(i);
			String capacity = (String) extractValue(
					"//Company/ProductionLine[@name='" + name + "']/Capacity",
					null).get(0);
			capacity = (capacity != null) ? capacity : "0";
			classProductionLine cpl = new classProductionLine(name, Float
					.parseFloat(capacity));
			productionLine.add(cpl);

		}
	}

	private void setWorkflows() {
		List workflows = extractValue("//Company/Workflow", "name");
		for (int i = 0; i < workflows.size(); i++) {
			String name_w = (String) workflows.get(i);
			List activity = extractValue("//Company/Workflow[@name='" + name_w
					+ "']/Activity", "name");
			for (int j = 0; j < activity.size(); j++) {
				String name_a = (String) activity.get(j);
				String spec = (String) extractValue(
						"//Company/Workflow[@name='" + name_w
								+ "']/Activity[@name='" + name_a + "']/Spec",
						null).get(0);
				spec = (spec != null) ? spec : null;
				//				List splitList = extractValue
				// ("//Company/Workflow[@name='"+name_p+"']/Activity[@name='"+name_a+"']/Split",
				// null);
				//				boolean split = (splitList.size()>0)?
				// Boolean.parseBoolean((String) splitList.get(0)): false;
				String qtyPerUnit = (String) extractValue(
						"//Company/Workflow[@name='" + name_w
								+ "']/Activity[@name='" + name_a
								+ "']/QuantityPerUnit", null).get(0);
				qtyPerUnit = (qtyPerUnit != null) ? qtyPerUnit : "0";
				classAct cac = new classAct(name_a, spec, Integer
						.parseInt(qtyPerUnit));
				workflow.add(cac);

				List previous = extractValue("//Company/Workflow[@name='"
						+ name_w + "']/Activity[@name='" + name_a
						+ "']/Previous", "name");
				for (int k = 0; k < previous.size(); k++) {
					String aNamePre = (String) previous.get(k);
					String aNamePreSpec = (String) extractValue(
							"//Company/Workflow[@name='" + name_w
									+ "']/Activity[@name='" + name_a
									+ "']/Previous[@name='" + aNamePre
									+ "']/Spec", null).get(0);
					aNamePreSpec = (aNamePreSpec != null) ? aNamePreSpec : null;
					cac.addPrevious(aNamePre);

				}
				List next = extractValue("//Company/Workflow[@name='" + name_w
						+ "']/Activity[@name='" + name_a + "']/Next", "name");
				for (int k = 0; k < next.size(); k++) {
					String aNameNex = (String) next.get(k);
					String aNameNexSpec = (String) extractValue(
							"//Company/Workflow[@name='" + name_w
									+ "']/Activity[@name='" + name_a
									+ "']/Next[@name='" + aNameNex + "']/Spec",
							null).get(0);
					aNameNexSpec = (aNameNexSpec != null) ? aNameNexSpec : null;
					cac.addNexts(aNameNex);
				}
			}
		}
	}

	private void setInhouseActivities() {
		List inhouses = extractValue("//Company/InhouseActivity/Activity",
				"name");
		for (int i = 0; i < inhouses.size(); i++) {
			String name = (String) inhouses.get(i);
			String pName = (String) extractValue(
					"//Company/InhouseActivity/Activity[@name='" + name
							+ "']/ProductionLineApplied", null).get(0);
			String spec = (String) extractValue(
					"//Company/InhouseActivity/Activity[@name='" + name
							+ "']/Spec", null).get(0);
			spec = (spec != null) ? spec : null;
			String setupCost = (String) extractValue(
					"//Company/InhouseActivity/Activity[@name='" + name
							+ "']/SetupCost", null).get(0);
			String unitCost = (String) extractValue(
					"//Company/InhouseActivity/Activity[@name='" + name
							+ "']/UnitCost", null).get(0);
			String setupTime = (String) extractValue(
					"//Company/InhouseActivity/Activity[@name='" + name
							+ "']/SetupTime", null).get(0);
			String UnitProductionTime = (String) extractValue(
					"//Company/InhouseActivity/Activity[@name='" + name
							+ "']/UnitProductionTime", null).get(0);

			setupCost = (setupCost != null) ? setupCost : "0";
			unitCost = (unitCost != null) ? unitCost : "0";
			setupTime = (setupTime != null) ? setupTime : "0";
			UnitProductionTime = (UnitProductionTime != null) ? UnitProductionTime
					: "0";

			classInhouseActivity cia = new classInhouseActivity(name, spec,
					pName, Float.parseFloat(setupCost), Float
							.parseFloat(unitCost), Float.parseFloat(setupTime),
					Float.parseFloat(UnitProductionTime));

			inhouseActivities.add(cia);

			try {
				List iComponentName = extractValue(
						"//Company/InhouseActivity/Activity[@name='" + name
								+ "']" + "/StandardPartsConsumption",
						"ComponentName");
				List iconsumptionPerUnit = extractValue(
						"//Company/InhouseActivity/Activity[@name='" + name
								+ "']" + "/StandardPartsConsumption",
						"consumptionPerUnit");
				for (int k = 0; k < iComponentName.size(); k++) {
					String componentName = (String) iComponentName.get(k);
					String consumptionPerUnit = (String) iconsumptionPerUnit
							.get(k);
					consumptionPerUnit = (consumptionPerUnit != null) ? consumptionPerUnit
							: "0";
					classStdPart csp = new classStdPart(componentName, Integer
							.parseInt(consumptionPerUnit));
					cia.addStdPart(csp);
				}
			} catch (Exception e) {
				System.out.println("InhouseActivities:" + e);
			}

		}
	}

	private void setSuppliers() {
		List activities = new ArrayList();
		List supplier = extractValue("//Company/Supplier", "name");
		for (int i = 0; i < supplier.size(); i++) {
			String name = (String) supplier.get(i);
			String agentName = (String) extractValue(
					"//Company/Supplier[@name='" + name + "']/AgnetName", null)
					.get(0);
			/*
			 * String capacity = (String) extractValue
			 * ("//Company/Supplier[@name='"+name+"']/EstimatedCapacity",
			 * null).get(0); String trust = (String) extractValue
			 * ("//Company/Supplier[@name='"+name+"']/TrustLevel", null).get(0);
			 */
			List activity = extractValue("//Company/Supplier[@name='" + name
					+ "']/Activity", "name");

			for (int k = 0; k < activity.size(); k++) {
				String nameAc = (String) activity.get(k);
				String spec = (String) extractValue(
						"//Company/Supplier[@name='" + name
								+ "']/Activity[@name='" + nameAc + "']/Spec",
						null).get(0);
				spec = (spec != null) ? spec : null;
				/*
				 * String setupTime = (String) extractValue
				 * ("//Company/Supplier[@name='"+name+"']/Activity[@name='"+nameAc+"']/EstimatedSetupTime",
				 * null).get(0); String itemProductionTime = (String)
				 * extractValue
				 * ("//Company/Supplier[@name='"+name+"']/Activity[@name='"+nameAc+"']/EstimatedItemProductionTime",
				 * null).get(0); String orderingCost = (String) extractValue
				 * ("//Company/Supplier[@name='"+name+"']/Activity[@name='"+nameAc+"']/EstimatedOrderingCost",
				 * null).get(0); String itemCost = (String) extractValue
				 * ("//Company/Supplier[@name='"+name+"']/Activity[@name='"+nameAc+"']/EstimatedItemCost",
				 * null).get(0); String qualityLevel = (String) extractValue
				 * ("//Company/Supplier[@name='"+name+"']/Activity[@name='"+nameAc+"']/QualityLevel",
				 * null).get(0);
				 */
				classOutsourcing co = new classOutsourcing(nameAc, spec);
				activities.add(co);
			}
			classSupplier cs = new classSupplier(name, agentName, 0, 0,
					activities);
			suppliers.add(cs);
		}
	}

	private void setCustomers() {
		List customer = extractValue("//Company/Customer", "name");
		for (int i = 0; i < customer.size(); i++) {
			String name = (String) customer.get(i);
			String agentName = (String) extractValue(
					"//Company/Customer[@name='" + name + "']/AgnetName", null)
					.get(0);
			List rp = new ArrayList();

			List requestProducts = extractValue("//Company/Customer[@name='"
					+ name + "']/RequestProduct", "name");

			for (int k = 0; k < requestProducts.size(); k++) {
				String pName = (String) requestProducts.get(k);
				String spec = (String) extractValue(
						"//Company/Customer[@name='" + name
								+ "']/RequestProduct[@name='" + pName
								+ "']/Spec", null).get(0);
				spec = (spec != null) ? spec : null;
				classRequestProduct crp = new classRequestProduct(pName, spec, 2.0);
				rp.add(crp);
			}
			classCustomer cus = new classCustomer(name, agentName, rp);

			customers.add(cus);
		}
	}

	private Document parseXmlFile(String _filename) {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory
					.newInstance();
			factory.setIgnoringComments(true);
			factory.setExpandEntityReferences(false);
			Document doc = factory.newDocumentBuilder().parse(
					new File(_filename));
			return doc;
		} catch (Exception e) {
		}
		return null;
	}

	private List extractValue(String _xpath, String _attributeName) {
		List l = new ArrayList();
		String value = null;
		try {
			NodeList nodelist = XPathAPI.selectNodeList(this.doc, _xpath);
			for (int i = 0; i < nodelist.getLength(); i++) {
				Element elem = (Element) nodelist.item(i);
				if (_attributeName != null)
					value = elem.getAttribute(_attributeName);
				else {
					Text t = (Text) elem.getFirstChild();
					value = t.getData();
				}
				l.add(value);
			}
		} catch (Exception e) {
			System.out.println(_xpath + ":" + e);
		}
		if (l.size() == 0)
			l.add(null);
		return l;
	}

	public String[] getProductParameters(String _cusName, String _proName) {
		String workflowName = (String) extractValue(
				"//Company/Product[@name='" + _proName + "']/Workflow", null)
				.get(0);
		String setupTime = null, UnitProductionTime = null, capacity = null;
		List activity = extractValue("//Company/Workflow[@name='"
				+ workflowName + "']/Activity", "name");
		for (int j = 0; j < activity.size(); j++) {
			String name_a = (String) activity.get(j);
			String pName = (String) extractValue(
					"//Company/InhouseActivity/Activity[@name='" + name_a
							+ "']/ProductionLineApplied", null).get(0);
			if (pName != null) {
				setupTime = (String) extractValue(
						"//Company/InhouseActivity/Activity[@name='" + name_a
								+ "']/SetupTime", null).get(0);
				UnitProductionTime = (String) extractValue(
						"//Company/InhouseActivity/Activity[@name='" + name_a
								+ "']/UnitProductionTime", null).get(0);

				capacity = (String) extractValue(
						"//Company/ProductionLine[@name='" + pName
								+ "']/Capacity", null).get(0);
			}
		}
		setupTime = (setupTime != null) ? setupTime : "0";
		UnitProductionTime = (UnitProductionTime != null) ? UnitProductionTime
				: "0";
		capacity = (capacity != null) ? capacity : "0";
		String[] str = {setupTime, UnitProductionTime, capacity};
		return str;
	}

	public List getPotentialWorkflow(String _proName) {
		List wf = new ArrayList();
		String workflowName = (String) extractValue(
				"//Company/Product[@name='" + _proName + "']/Workflow",
				null).get(0);
		List activity = extractValue("//Company/Workflow[@name='"
				+ workflowName + "']/Activity", "name");
		for (int j = 0; j < activity.size(); j++) {
			String name_a = (String) activity.get(j);
			String spec = (String) extractValue(
					"//Company/Workflow[@name='" + workflowName
							+ "']/Activity[@name='" + name_a + "']/Spec", null)
					.get(0);
			spec = (spec != null) ? spec : null;
			String qtyPerUnit = (String) extractValue(
					"//Company/Workflow[@name='" + workflowName
							+ "']/Activity[@name='" + name_a
							+ "']/QuantityPerUnit", null).get(0);
			qtyPerUnit = (qtyPerUnit != null) ? qtyPerUnit : "0";
			classAct cac = new classAct(name_a, spec, Integer
					.parseInt(qtyPerUnit));
			wf.add(cac);

			List previous = extractValue("//Company/Workflow[@name='"
					+ workflowName + "']/Activity[@name='" + name_a
					+ "']/Previous", "name");
			for (int k = 0; k < previous.size(); k++) {
				String aNamePre = (String) previous.get(k);
				String aNamePreSpec = (String) extractValue(
						"//Company/Workflow[@name='" + workflowName
								+ "']/Activity[@name='" + name_a
								+ "']/Previous[@name='" + aNamePre + "']/Spec",
						null).get(0);
				aNamePreSpec = (aNamePreSpec != null) ? aNamePreSpec : null;
				cac.addPrevious(aNamePre);

			}
			List next = extractValue(
					"//Company/Workflow[@name='" + workflowName
							+ "']/Activity[@name='" + name_a + "']/Next",
					"name");
			for (int k=0; k<next.size(); k++) {
				String aNameNex = (String) next.get(k);
				String aNameNexSpec = (String) extractValue(
						"//Company/Workflow[@name='" + workflowName
								+ "']/Activity[@name='" + name_a
								+ "']/Next[@name='" + aNameNex + "']/Spec",
						null).get(0);
				aNameNexSpec = (aNameNexSpec != null) ? aNameNexSpec : null;
				cac.addNexts(aNameNex);
			}
		}
		return wf;
	}
	
}
