package organization.operation.sales;

import organization.communicationOntology.*;
import organization.dataschema.*;
import organization.operation.OperationHub;
import organization.operation.Department;
import organization.operation.setting;

import java.util.List;
import java.util.ArrayList;

public class SalesManager extends Department {
	private OrderManagement ordm;
	private InquiryManagement inqm;
	private ProposalManagement prom;

	public SalesManager(OperationHub _ipi) {
		super(_ipi);
		this.ordm = new OrderManagement(this);
		this.inqm = new InquiryManagement(this);
		this.prom = new ProposalManagement(this);
	}

	public void updateManagementLogic(Object _obj) {
		if (_obj instanceof OrderManagement)
			this.ordm = (OrderManagement) _obj;
		else if (_obj instanceof InquiryManagement)
			this.inqm = (InquiryManagement) _obj;
		else if (_obj instanceof ProposalManagement)
			this.prom = (ProposalManagement) _obj;
	}

	public classProject generateInquiry(classProject _cp) {
		return null;
	}

	public Proposal generateProposal(Inquiry _inq, int _op_propose, int _op_OFP) {
		Proposal proposal = null;
		if (_op_propose == setting.PROPOSE_DIRECTLY)
			proposal = generateDirectProposal(_inq, _op_OFP);
		else if (_op_propose == setting.PROPOSE_AFTER_SIMULATION)
			proposal = generateSimulatedProposal(_inq, _op_OFP);
		return proposal;
	}

	public Proposal generateDirectProposal(Inquiry _inq, int _op_OFP) {
		return this.prom.generateDirectProposal(_inq, _op_OFP);
	}

	public Proposal generateSimulatedProposal(Inquiry _inq, int _op_OFP) {
		return this.prom.generateSimulatedProposal(_inq, _op_OFP);
	}

	public Proposal generatePreciseProposal(Proposal _proposal) {
		return this.prom.generatePreciseProposal(_proposal);
	}

	public void proposePreciseProposal2Customer(Proposal _proposal) {
		Proposal proposal2Customer = this.prom
				.generatePreciseProposal(_proposal);
		deliverProposal(proposal2Customer);
	}

	public Proposal response2CounterProposal(Proposal _counterProposal) {
		return _counterProposal;
	}

	public classProject generateAllOrder(classProject _cp) {
		return null;
	}

	public classProject getOFP(Object _obj, int _op_OFP) {
		return this.ohub.prm.getOFP(_obj, _op_OFP);
	}

	public classProject simulateComingOrder(classProject _cp) {
		return _cp;
	}

	//to be finished
	public Proposal getSimulatedProposal(classProject _cp) {
		Proposal proposal = null;
		return proposal;
	}

	//_obj can only be proposal or order
	public classProject getRecordedClassProject(Object _obj) {
		return null;
	}

	public classProject getRecordedAllActivity(classProject _cp) {
		return null;
	}

	//receive inquiry
	public void receiveInquiry(Inquiry _inquiry) {
		int op_propose = setting.PROPOSE_DIRECTLY;
		int op_OFP = setting.GET_PROCESS_DEFAULT;
		this.receiveInquiry(_inquiry, op_propose, op_OFP);
	}

	public void receiveInquiry(Inquiry _inquiry, int _op_propose) {
		int op_OFP = setting.GET_PROCESS_DEFAULT;
		this.receiveInquiry(_inquiry, _op_propose, op_OFP);
	}

	public void receiveInquiry(Inquiry _inquiry, int _op_propose, int _op_OFP) {
		recordInquiry(_inquiry);
		this.inqm.receiveInquiry(_inquiry, _op_propose, _op_OFP);
	}

	//receive order
	public void recieveOrder(Order _order, int _op_fulfill, int _op_propose) {
		recordOrder(_order);
		this.ordm.recieveOrder(_order, _op_fulfill, _op_propose);
	}

	public void receiveCounterProposal(Proposal _counterProposal) {
		recordCounterProposal(_counterProposal);
		this.prom.receiveCounterProposal(_counterProposal);
	}

	//record all data
	public void recordProposal(Proposal _proposal) {
		this.ohub.datam.receivedProposal.add(_proposal);
	}

	public void recordCounterProposal(Proposal _counterProposal) {
		this.ohub.datam.receivedProposal.add(_counterProposal);
	}

	public void recordInquiry(Inquiry _inquiry) {
		this.ohub.datam.receivedInquiries.add(_inquiry);
	}

	public void recordOrder(Order _order) {
		this.ohub.datam.receivedOrders.add(_order);
	}

	public void recordClassProcess(classProject _cp) {

	}

	public void deliverProposal(Proposal _proposal) {
		this.org.deliverObject(_proposal);
	}

	public void deliverOrderAcknowledgement(OrderAcknowledgement _oa) {
		this.ohub.deliverOrderAcknowledgement(_oa);
	}

	protected void response2InquiryAfterPlanning(Inquiry _inquiry, int _op_OFP) {
		classProject cp = this.getOFP(_inquiry, _op_OFP);
		cp = this.generateInquiry(cp);
		this.recordClassProcess(cp);
		this.deliverInquiry(cp);
	}

	protected void fulfillOrderBasedOnPriorPlanning(Order _order) {
		classProject cp = this.getRecordedClassProject(_order);
		cp = this.generateAllOrder(cp);
		this.recordClassProcess(cp);
		this.deliverOrder(cp);
	}

	public void deliverInquiry(classProject _cp) {
		this.ohub.om.deliverInquiry(_cp);
	}

	public void deliverOrder(classProject _cp) {
		this.ohub.om.deliverOrder(_cp);
	}

	public classProject planEstimatedSchedule(classProject _cp) {
		return _cp;
	}

	public int getEstimatedCost(classProject _cp) {
		int estimatedCost = 0;
		return estimatedCost;
	}

	public int getPrice(classProject _cp) {
		int estimatedCost = 0;
		return estimatedCost;
	}

	public void scheduleInhouseActivity(classProject _cp) {

	}

	public void planInhouseActivity(classProject _cp) {

	}

	public List getFinishedGoodsDelivery() {
		List finishedGoodsDeliveries = new ArrayList();
		int t = Clock.getPeriod();
		List inhouseActivities = ohub.datam.inhouseActivities;
		for (int i=0; i<inhouseActivities.size();i++){
			classInhouseData cid = (classInhouseData) inhouseActivities.get(i);
			classInhouseRecord[] cir  = cid.cir;
			classInhouseRecord cirt = cir[t];
			int finishedQuantity = 0;
			for (int j=0;j<t;j++){
				classInhouseRecord cirj = cir[j];
				if (j+cirj.leadtime==t) {
					finishedQuantity += cirj.makeQuantity;
					Order order = this.ohub.datam.getOriginalOrder(cid, j);
					DetailedDeliveryPlan detailedDeliveryPlan = 
						(DetailedDeliveryPlan) order.getAgreedProposal().getDetailedDeliveryPlan().get(0);
					GoodsDelivery delivery = new GoodsDelivery(order,
							detailedDeliveryPlan, cirj.makeQuantity,
							Clock.getTime());
					finishedGoodsDeliveries.add(delivery);
				}
			}
			int shortageQuantity = 
				cirt.finishedQuantity - cirt.requestedQuantity; 
			cid.updateInhouseRecord(finishedQuantity, shortageQuantity);
		}
		return finishedGoodsDeliveries;
	}	
}
