package organization.beliefSystem;

import java.util.List;
import java.util.ArrayList;
import organization.dataschema.*;
import organization.beliefSystem.dataschema.*;

public class inhouse {
	swarmOrganization swarmOrg;

	private List memory;

	public inhouse(swarmOrganization _swarmOrg) {
		this.swarmOrg = _swarmOrg;
		memory = this.swarmOrg.memory;
	}
	
	public List getInhousePlanning(){
		List inhousePlannings = new ArrayList();
		int t = Clock.getPeriod();
		if (t > 0) {
			for (int i=0; i<memory.size(); i++) {
				DataO ro = (DataO) memory.get(i);
				InhouseRecord[][] ihr = ro.ih;
				int endSlot = ihr[0].length - 1;
				int makeQuantityInPeriod = ihr[t][endSlot].makeQuantityInPeriod;
				int requestedQuantityInPeriod = ihr[t][endSlot].customerDemandInPeriod;
				DataC rc = getCustomerRecordCorresponding2SelfRecord(ro);
				int forecastedQuantity = rc.f[t][endSlot].forecastedCustomerDemandInPeriod;
				InhouseData ihd = new InhouseData(t, ro.cusName, ro.pName, 
						ro.spec, requestedQuantityInPeriod, forecastedQuantity, makeQuantityInPeriod);
				inhousePlannings.add(ihd);
			}
		}
		return inhousePlannings;
	}

	public void computeLeadtimeOfMakeQuantityInPeriod() {
		int t = Clock.getPeriod();
		if (t > 0) {
			for (int i=0; i<memory.size(); i++) {
				DataO ro = (DataO) memory.get(i);
				InhouseRecord[][] ihr = ro.ih;
				int endSlot = ihr[0].length - 1;
				int makeQuantityInPeriod = ihr[t][endSlot].makeQuantityInPeriod;
				int leadtimeOfMakeQuantityInPeriod = (int) Math.ceil(((ro.setupTime + makeQuantityInPeriod
						* ro.unitTime)/ro.capacity));
				ihr[t][endSlot].leadtimeOfMakeQuantityInPeriod = leadtimeOfMakeQuantityInPeriod;
			}
		}
	}

	public void computeQuantityOfFinishedGoods() {
		int t = Clock.getPeriod();
		int quantity = 0;
		if (t > 0) {
			for (int i=0; i<memory.size(); i++) {
				DataO r = (DataO) memory.get(i);
				InhouseRecord[][] ihr = r.ih;
				int endSlot = ihr[0].length - 1;
				for (int j=0;j<t;j++) {
					if ((j+ihr[j][endSlot].leadtimeOfMakeQuantityInPeriod)==t){
						quantity += ihr[j][endSlot].makeQuantityInPeriod;
					}
				}
				ihr[t][endSlot].finishedQuantity = quantity;
			}
		}
	}

	public void computeShortage() {
		int t = Clock.getPeriod();
		if (t > 0) {
			for (int i = 0; i < memory.size(); i++) {
				DataO r = (DataO) memory.get(i);
				InhouseRecord[][] ihr = r.ih;
				int endSlot = ihr[0].length - 1;
				ihr[t][endSlot].shortage = ihr[t][endSlot].finishedQuantity
						- ihr[t][endSlot].customerDemandInPeriod;
			}
		}
	}

	public DataC getCustomerRecordCorresponding2SelfRecord(DataO _ro) {
		DataC rc = null;
		String cusName = _ro.cusName;
		String pName = _ro.pName;
		String spec = _ro.spec;
		List customers = this.swarmOrg.env.getCustomers();
		for (int i=0; i<customers.size();i++){
			customerSwarm customer = (customerSwarm) customers.get(i);
			if (customer.name.equals(cusName)){
				List cusMem = customer.memory;
				for (int j=0; j<cusMem.size();j++){
					DataC r = (DataC) cusMem.get(j);
					if ((r.pName.equals(pName))&(r.spec.equals(spec))) {
						return r;
					}
				}
			}
		}
		return rc;
	}
	
}
