package organization.operation.purchasing;

import java.util.List;
import organization.communicationOntology.*;
import organization.dataschema.*;
import organization.operation.*;
import organization.dataschema.Clock;

public class PurchasingManager extends Department {

	private InquiryManagement inm;
	private OrderManagement orm;
	private ProposalManagement prm;

	public PurchasingManager(OperationHub _ipi) {
		super(_ipi);
		this.inm = new InquiryManagement(this);
		this.orm = new OrderManagement(this);
		this.prm = new ProposalManagement(this);
	}

	public void updateManagementLogic(Object _obj) {
		if (_obj instanceof OrderManagement)
			this.orm = (OrderManagement) _obj;
		else if (_obj instanceof InquiryManagement)
			this.inm = (InquiryManagement) _obj;
		else if (_obj instanceof ProposalManagement)
			this.prm = (ProposalManagement) _obj;
	}

	public void deliverInquiry(classProject _cp) {
		List workflow = _cp.workflow;
		for (int i = 0; i < workflow.size(); i++) {
			classActivity ca = (classActivity) workflow.get(i);
			Object inqOrd = ca.inqOrd;
			if ((inqOrd != null) & (inqOrd instanceof Inquiry)) {
				Inquiry inquiry = (Inquiry) inqOrd;
				this.org.deliverObject(inquiry);
			}
		}
	}

	public boolean receiveProposal(Proposal _proposal) {
		//codes are removed
		return this.prm.receiveAllProposal(_proposal);
	}

	public void deliverOrder(classProject _cp) {
		List workflow = _cp.workflow;
		for (int i = 0; i < workflow.size(); i++) {
			classActivity ca = (classActivity) workflow.get(i);
			Object inqOrd = ca.inqOrd;
			if ((inqOrd != null) & (inqOrd instanceof Order)) {
				Order order = (Order) inqOrd;
				this.org.deliverObject(order);
			}
		}
	}

	public Order transformInquiry2Order(Inquiry _inquiry) {
		return this.orm.transfromInquiry2Order(_inquiry);
	}
	
	
	public List trsnsformOrderData2Order(List _orders) {
		return this.orm.trsnsformSimulatedOrderData2Order(_orders);
	}

	public void resetDailySeqNo() {
		this.inm.resetDailySeqNo();
	}

	public void proposePreciseProposal2Customer(Proposal _proposal) {
		this.ohub.sm.proposePreciseProposal2Customer(_proposal);
	}

	public classProject generateDirectOrder(classProject _cp) {
		return this.orm.generateDirectOrder(_cp);
	}

	public Proposal generateCounterProposal(Proposal _proposal) {
		return _proposal;
	}

	public Order generateOrder(Inquiry _inq) {
		String orderPlacingDate = Clock.getTime();
		float qualityLevel = _inq.getQualityLevel();
		CompleteDeliveryPlan agreedProposal = null;
		return new Order(_inq, orderPlacingDate, agreedProposal, qualityLevel);
	}

	public Proposal getRecordedProposal(Inquiry _inquiry) {
		return null;
	}

	public classProject generateInquiry(classProject _cp) {
		return this.inm.generateInquiry(_cp);
	}

	public String getRequiredDatetime(classActivity _ca) {
		String requiredDatetime;
		String earliestEndingDatetime = _ca.earliestEndingDatetime;
		requiredDatetime = earliestEndingDatetime;
		return requiredDatetime;
	}

	public void recordInquiry(Inquiry _inquiry, String _originalInqNo) {

	}

	public Company getSupplier(String _supplierName) {
		return this.ohub.partners.getSupplier(_supplierName);
	}

	public void recordInhouseActivity(classInhouseActivity _cia,
			classProject _cp) {

	}

	public classProject generateAllOrder(classProject _cp) {
		return this.orm.generateAllOrder(_cp);
	}

	public void deliverProposal(Proposal _proposal) {
		this.org.deliverObject(_proposal);
	}
}
