package organization;

import java.util.List;

import organization.beliefSystem.dataschema.InhouseData;
import organization.communicationOntology.*;
import organization.dataschema.Clock;
import organization.jade.behaviour.RMICheck;
import organization.operation.OrganizationProfile;

public class OrganizationImpl extends OrganizationProfile {
	protected JadeAgentContainerInitiator JACI;
	public SimulatedAgentImpl sa;
	public PetriNet petrinet;

	public OrganizationImpl(String _name, String[] _args) {
		super(_name);
		sa = new SimulatedAgentImpl(this, _args);
		petrinet = new PetriNet(this);
	}

	public void setJadeEnvironment(boolean _newPlatform) {
		String host = this.JadePlatformHost;
		int port = this.JadePlatformPort;
		String containerName = this.JadePlatformContainer;
		try {
			if (_newPlatform) {
				Runtime.getRuntime().exec("java jade.Boot -gui -port " + port);
				//sniffer
				JACI.snifferingAllAgents();
			}
		} catch (Exception e) {
			System.out.println(e);
		}
		RMICheck rmi = new RMICheck(host, port);
		do {
		} while (!rmi.isRMIawake());

		//initialize a new agent container in Jade platform
		this.JACI = new JadeAgentContainerInitiator(host, port, containerName,
				this);

		//for company
		String agentClassName = "PhysicalAgent";
		JACI.registerAgent(agentName, agentClassName);
	}

	public void destroyJadeEnvironment() {
		JACI.destoryAgentContainer();
	}

	public void receiveOrder(Order _order) {
		sa.receiveOrder(_order);
		petrinet.recieveOrder(_order);
	}

	public void receiveInquiry(Inquiry _inquiry) {
		petrinet.receiveInquiry(_inquiry, 0);
	}

	public void receiveProposal(Proposal _proposal) {
		petrinet.receiveProposal(_proposal);
	}

	public void receiveCounterProposal(Proposal _proposal) {
		petrinet.receiveProposal(_proposal);
	}

	public void receiveDelivery(GoodsDelivery _delivery) {
		petrinet.receiveGoods(_delivery);
	}

	public void receiveRefuseProposal(Proposal _proposal) {
		petrinet.receiveRefuseProposal(_proposal);
	}

	public void receiveOrderAcknowledgement(OrderAcknowledgement _oa) {
		petrinet.receiveOrderAcknowledgement(_oa);
	}

	public void receiveGoods(GoodsDelivery _delivery) {
		petrinet.receiveGoods(_delivery);
	}

	public void updateTime(Time _time) {
		Clock.period = _time.getPeriod();
		Clock.slot = _time.getSlot();
		sa.simulateSupplyChain();
		List orderData = sa.getOrdersToSuppliers();
		if (orderData!=null){
			List orders = petrinet.om.trsnsformOrderData2Order(orderData);
			for (int i=0; i<orders.size();i++){
				Order order = (Order) orders.get(i);
				deliverObject(order);
			}
		}
		
		int t = Clock.getPeriod();
		int ts = Clock.getSlot();
		if (ts == sa.swarmModel.timeSlotLength-1) {
			List inhousePlannings =  sa.getInhousePlanning();
						
			if (inhousePlannings.size()>0) {
				petrinet.planInhouseActivities(inhousePlannings);
			}
			List deliveries = petrinet.getFinishedGoodsDelivery();
			for (int i=0; i<deliveries.size();i++){
				GoodsDelivery delivery = (GoodsDelivery) deliveries.get(i);

				deliverObject(delivery);			
			}
		}
		deliverObject(_time);
		System.gc();
		if (t==sa.swarmModel.timePeriodLength-1){
			sa.drop();
			JACI.destoryAgentContainer();
			petrinet.performance.outputForecastAndShortage();
		}
	}

	// trigger physical agents
	public void deliverObject(Object _obj) {
		this.JACI.deliverObject(_obj);
	}

}
