package organization.beliefSystem;

import organization.beliefSystem.dataschema.*;


public class method3 extends methodForecast {
	private modifiedAGNES clusteringEngine;

	public method3(int _winSize, DataC _r) {
		super(_winSize, _r);
		this.clusteringEngine = new modifiedAGNES();
	}

	public int generateDemand(int _t, int _ts, DataC _r) {
		int demand = 0;
		this.r = _r;
		int slots = r.o[_t].length;
		if (_t == 0) {
			OutsourceRecord o = r.o[_t][_ts];
			demand = o.actualDemandInSlot;
		} else {
			if (isSlot2Deliver(_ts)) {
				demand = getExpectedDemandInCluster(_ts);
			}
		}
		if (_ts == slots - 1)
			updateDemandModel(_t);
		return demand;
	}

	private int getExpectedDemandInCluster(int _ts) {
		int x = this.clusteringEngine.optimalMatrix.length;
		int y = this.clusteringEngine.optimalMatrix[0].length;
		int tsxPos = x - 1;
		int slot = 0;
		int clusterNo = 0;
		int total = 0;
		for (int i = 0; i < y; i++) {
			slot = this.clusteringEngine.optimalMatrix[tsxPos][i];
			if (slot == _ts) {
				clusterNo = i;
				break;
			}
		}
		for (int i = 0; i < x - 1; i++)
			total += this.clusteringEngine.optimalMatrix[i][clusterNo];
		return (total / x - 1);
	}

	private boolean isSlot2Deliver(int _ts) {
		boolean result = false;
		int x = this.clusteringEngine.optimalMatrix.length;
		int y = this.clusteringEngine.optimalMatrix[0].length;
		int tsxPos = x - 1;
		int endSlot = 0;
		for (int i = 0; i < y; i++) {
			endSlot = this.clusteringEngine.optimalMatrix[tsxPos][i];
			if (endSlot == _ts) {
				result = true;
				break;
			}
		}
		return result;
	}

	private void updateDemandModel(int _t) {
		int slots = r.o[_t].length;
		int b = _t - this.winSize;
		b = (b > 0) ? b : 0;
		int[][] M = new int[_t - b + 1][slots];

		OutsourceRecord o;

		for (int i = b; i < _t + 1; i++)
			for (int j = 0; j < slots; j++) {
				o = r.o[i][j];
				M[i - b][j] = o.actualDemandInSlot;
			}
		clusteringEngine.getOptimallyClusteredMatrix(M);
	}
}
