package organization.beliefSystem;

import java.util.*;
import organization.dataschema.*;
import organization.beliefSystem.dataschema.*;

public class sales {

	swarmOrganization swarmOrg;
	private List memory;
	private int methodType;

	public sales(swarmOrganization _org) {
		swarmOrg = _org;
		memory = _org.memory;
		methodType = _org.env.methodType;
	}

	public void computePurchaseQuantity(customerSwarm _customer) {
		int t = Clock.getPeriod();
		int ts = Clock.getSlot();
		List cusMem = _customer.memory;
		String cusName = _customer.name;
		if (t > 0) {
			for (int i = 0; i < cusMem.size(); i++) {
				computeLeadTime(t, ts, i, cusMem, cusName);
				computeOrderUpToPoint(t, ts, i, cusMem, cusName);
				computeOrderQuantity(t, ts, i, cusMem, cusName);
			}
		}
	}
	
	private void computeLeadTime(int _t, int _ts, int _index, List _cusMem,
			String _cusName) {
		int quantity;
		DataC rc = (DataC) _cusMem.get(_index);

		DataO ro = getRecordCorresponding2CustomerRecord(rc, _cusName);
		ForecastRecord[][] forecast = rc.f;
		InhouseRecord[][] inhouse = ro.ih;
		if (methodType==3) 
			quantity = forecast[_t][_ts].forecastedCustomerDemandInSlot;
		else
			quantity = forecast[_t][_ts].forecastedCustomerDemandInPeriod;
		inhouse[_t][_ts].leadtimeOfDemand = Math.ceil((ro.setupTime + quantity
				* ro.unitTime) / ro.capacity);
	}

	private void computeOrderUpToPoint(int _t, int _ts, int _index,
			List _cusMem, String _cusName) {
		int quantity;
		DataC rc = (DataC) _cusMem.get(_index);
		DataO ro = getRecordCorresponding2CustomerRecord(rc, _cusName);
		ForecastRecord[][] forecast = rc.f;
		InhouseRecord[][] inhouse = ro.ih;
		if (methodType==3){ 
			quantity = forecast[_t][_ts].forecastedCustomerDemandInSlot;
		}
		else {
			quantity = forecast[_t][_ts].forecastedCustomerDemandInPeriod;
			}
		int orderUpTo = (int) (inhouse[_t][_ts].leadtimeOfDemand
				* quantity + ro.constantOfOrderUpTo
				* forecast[_t][_ts].standardDeviation);
		inhouse[_t][_ts].makeUpTo = orderUpTo;
	}

	public void computeOrderQuantity(int _t, int _ts, int _index, List _cusMem,
			String _cusName) {
		int quantity;
		DataC rc = (DataC) _cusMem.get(_index);
		DataO ro = getRecordCorresponding2CustomerRecord(rc, _cusName);
		OutsourceRecord[][] outsourceC = rc.o;
		InhouseRecord[][] inhouseO = ro.ih;
		OutsourceRecord[][] o = ro.o;
		if (methodType==3){ 
			quantity = outsourceC[_t-1][_ts].actualDemandInSlot;
		}
		else {
			quantity = outsourceC[_t-1][_ts].totalDemandInPeriod;
			}
		int requiredQuantity = (int) (inhouseO[_t][_ts].makeUpTo
				- inhouseO[_t-1][_ts].makeUpTo + quantity);
		if (requiredQuantity<0) requiredQuantity=0;
		inhouseO[_t][_ts].customerDemand = outsourceC[_t][_ts].actualDemandInSlot;
		inhouseO[_t][_ts].customerDemandInPeriod = outsourceC[_t][_ts].totalDemandInPeriod;
		inhouseO[_t][_ts].makeQuantity = requiredQuantity;
		inhouseO[_t][inhouseO[_t].length-1].makeQuantityInPeriod += requiredQuantity;
		o[_t][_ts].actualDemandInSlot = requiredQuantity;
		o[_t][o[_t].length-1].totalDemandInPeriod += requiredQuantity;
	}

	public DataO getRecordCorresponding2CustomerRecord(DataC _rc,
			String _cusName) {
		String pName = _rc.pName;
		String spec = _rc.spec;
		DataO ro = null;
		for (int i = 0; i < memory.size(); i++) {
			ro = (DataO) memory.get(i);
			String ocName = ro.cusName;
			String opName = ro.pName;
			String ospec = ro.spec;
			if (ocName.equals(_cusName) & opName.equals(pName)
					& ospec.equals(spec))
				break;
		}
		return ro;
	}

}
