package organization.jade.behaviour;

import jade.lang.acl.ACLMessage;

import jade.core.*;
import jade.core.behaviours.OneShotBehaviour;

import jade.content.lang.Codec;
import jade.content.lang.sl.*;

import jade.content.onto.*;
import jade.content.onto.basic.*;

import organization.*;
import organization.communicationOntology.*;

/**
 * <p>
 * Title: Agent's Behaviour
 * </p>
 * <p>
 * Description: Send Inquiry Message to potential partner
 * </p>
 * <p>
 * Copyright: Copyright (c) 2003
 * </p>
 * <p>
 * Company: NSYSU MAIS Lab
 * </p>
 * 
 * @author Shyh-Ming Lin
 * @version 1.0
 */

public class InquiryDelivering extends OneShotBehaviour {
	private Codec codec = new SLCodec();

	protected Inquiry inquiry;

	protected PhysicalAgentImpl myAgent;

	private Ontology ontology = CommunicationOntology.getInstance();

	public InquiryDelivering(PhysicalAgentImpl a, Inquiry inq) {
		super(a);
		this.inquiry = inq;
		this.myAgent = a;
	}

	public void action() {
		Company receiver = this.inquiry.getReceiver();
		AID receiverAgent = new AID(receiver.getAgentName(), AID.ISLOCALNAME);
		Action action = new Action();
		action.setActor(receiverAgent);
		//		    action.setAction(inquiry);
		ACLMessage requestMsg = new ACLMessage(ACLMessage.CFP);
		requestMsg.addReceiver(receiverAgent);
		requestMsg.setLanguage(codec.getName());
		requestMsg.setOntology(ontology.getName());
		try {
			this.myAgent.getContentManager().fillContent(requestMsg, action);
			this.myAgent.send(requestMsg);
		} catch (Exception pe) {
			System.out.println(pe.getMessage());
		}
	}
}
