package organization.jade.behaviour;

import jade.core.behaviours.CyclicBehaviour;

import jade.content.*;
import jade.content.onto.basic.*;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

import organization.*;
import organization.communicationOntology.*;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: Copyright (c) 2003
 * </p>
 * <p>
 * Company: NSYSU MAIS Lab
 * </p>
 * 
 * @author Shyh-Ming Lin
 * @version 1.0
 */

public class InquiryReceiving extends CyclicBehaviour {
	private ContentManager manager;

	protected PhysicalAgentImpl myAgent;

	public InquiryReceiving(PhysicalAgentImpl a) {
		super();
		this.myAgent = a;
		manager = (ContentManager) a.getContentManager();
	}

	public void action() {
		Inquiry inquiry;
		ACLMessage msg = this.myAgent.receive(MessageTemplate
				.MatchPerformative(ACLMessage.CFP));
		if (msg != null) {
			try {
				Action action = (Action) manager.extractContent(msg);
				if (action.getAction() instanceof GoodsDelivery) {
					inquiry = (Inquiry) action.getAction();
					this.myAgent.receiveInquiry(inquiry);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			block();
		}
	}
}
