package organization.jade.behaviour;

import organization.PhysicalAgentImpl;
import organization.communicationOntology.*;

import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;

public class OrderAcknowledgementDelivering extends OneShotBehaviour {

	private Codec codec = new SLCodec();

	private Ontology ontology = CommunicationOntology.getInstance();

	private PhysicalAgentImpl myAgent;

	private OrderAcknowledgement orderAcknowledgement;

	public OrderAcknowledgementDelivering(PhysicalAgentImpl a,
			OrderAcknowledgement _oa) {
		super(a);
		this.orderAcknowledgement = _oa;
	}

	public void action() {
		Company receiver;
		ACLMessage proposeMsg;
		receiver = this.orderAcknowledgement.getOrder().getInquiry()
				.getSender();
		AID receiverAgent = new AID(receiver.getAgentName(), AID.ISLOCALNAME);
		Action action = new Action();
		action.setActor(receiverAgent);
		action.setAction(orderAcknowledgement);

		proposeMsg = new ACLMessage(ACLMessage.AGREE);

		proposeMsg.addReceiver(receiverAgent);
		proposeMsg.setLanguage(codec.getName());
		proposeMsg.setOntology(ontology.getName());

		try {
			this.myAgent.getContentManager().fillContent(proposeMsg, action);
			this.myAgent.send(proposeMsg);
		} catch (Exception pe) {
			System.out.println(pe.getMessage());
		}
	}

}
