package organization.operation.purchasing;

import java.util.List;
import java.util.ArrayList;

import organization.communicationOntology.*;
import organization.dataschema.*;
import organization.beliefSystem.dataschema.*;

public class OrderManagement {
	PurchasingManager om;

	public OrderManagement(PurchasingManager _om) {
		this.om = _om;
	}

	public classProject generateDirectOrder(classProject _cp) {
		_cp = this.om.generateInquiry(_cp);
		_cp = this.generateAllOrder(_cp);
		return _cp;
	}

	public classProject generateAllOrder(classProject _cp) {
		List workflow = _cp.workflow;
		for (int i = 0; i < workflow.size(); i++) {
			classActivity ca = (classActivity) workflow.get(i);
			Object inqOrd = ca.inqOrd;
			if (inqOrd != null) {
				Inquiry inq = (Inquiry) inqOrd;
				Order order = this.transfromInquiry2Order(inq);
				ca.inqOrd = order;
			}
		}
		return _cp;
	}

	public Order transfromInquiry2Order(Inquiry _inquiry) {
		Proposal proposal = this.om.getRecordedProposal(_inquiry);
		CompleteDeliveryPlan cdp = proposal.getDeliveryPlan();
		float qualityLevel = proposal.getQualityLevel();
		Order order = new Order(_inquiry, Clock.getTime(), cdp, qualityLevel);
		return order;
	}
	
	public List trsnsformSimulatedOrderData2Order(List _orders) {
		List outsources = new ArrayList();
		Clock.advanceOneSlot();
		Company sender = new Company(this.om.org.name, this.om.org.agentName);
		for (int i=0; i<_orders.size();i++){
			OrderData od = (OrderData) _orders.get(i);
			classSupplier cs = od.cs;
			Company receiver = new Company(cs.getName(), cs.getAgentName());
			Activity activity = new Activity(od.pName, od.spec,
					od.quantity);
			String inquiryDatetime = Clock.getTime();
			String requiredDatetime = ""; //reserved for future use
			float qualityLevel = 0; //reserved for future use
			String inqNo = Clock.getTime() + "00";
			Inquiry inq = new Inquiry(inqNo, receiver, sender, activity,
					inquiryDatetime, requiredDatetime, qualityLevel);
			String orderPlacingDatetime = Clock.getTime();
			//CompleteDeliveryPlan
			String datetime = ""; //reserved for future use
			int price = 0; //reserved for future use
			CompleteDeliveryPlan agreedProposal = new CompleteDeliveryPlan(
					datetime, od.quantity, price);
			Order order = new Order(inq, orderPlacingDatetime,
					agreedProposal, qualityLevel);
			outsources.add(order);
		}
		return outsources;
	}


}
