package organization.jade.behaviour;

import jade.core.behaviours.CyclicBehaviour;
import jade.content.*;

import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;

import jade.content.onto.basic.*;

import organization.*;
import organization.communicationOntology.*;

public class InformReceiving extends CyclicBehaviour {
	private ContentManager manager;

	protected PhysicalAgentImpl myAgent;

	public InformReceiving(PhysicalAgentImpl a) {
		super(a);
		this.myAgent = a;
		this.manager = (ContentManager) a.getContentManager();
	}

	public void action() {
		Time time;
		Order order;
		GoodsDelivery delivery;
		ACLMessage msg = this.myAgent.receive(MessageTemplate
				.MatchPerformative(ACLMessage.INFORM));
		if (msg != null) {
			try {
				Action action = (Action) manager.extractContent(msg);
				Object obj0 = action.getAction();
				if (obj0 instanceof Time) {
					time = (Time) obj0;
					myAgent.updateTime(time);
				} else if (obj0 instanceof Order) {
					order = (Order) obj0;
					myAgent.receiveOrder(order);
				} else if (obj0 instanceof GoodsDelivery) {
					delivery = (GoodsDelivery) action.getAction();
					myAgent.receiveGoods(delivery);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			block();
		}
	}
}
