package organization.jade.behaviour;

import jade.lang.acl.ACLMessage;

import jade.core.behaviours.CyclicBehaviour;

import jade.lang.acl.MessageTemplate;

import jade.content.*;
import jade.content.onto.basic.*;

import organization.PhysicalAgentImpl;
import organization.communicationOntology.*;

public class ProposalReceiving extends CyclicBehaviour {
	private ContentManager manager;

	protected PhysicalAgentImpl myAgent;

	protected Company self;

	public ProposalReceiving(PhysicalAgentImpl a) {
		super(a);
		myAgent = a;
		manager = (ContentManager) a.getContentManager();
	}

	public void action() {
		Action action;
		Proposal proposal;
		ACLMessage msg_propose = myAgent.receive(MessageTemplate
				.MatchPerformative(ACLMessage.PROPOSE));
		ACLMessage msg_refuse = myAgent.receive(MessageTemplate
				.MatchPerformative(ACLMessage.REFUSE));
		try {
			if (msg_propose != null) {
				action = (Action) manager.extractContent(msg_propose);
				if (action.getAction() instanceof Proposal) {
					proposal = (Proposal) action.getAction();
					this.myAgent.receiveProposal(proposal);
				} else if (action.getAction() instanceof Proposal) {
					proposal = (Proposal) action.getAction();
					myAgent.receiveCounterProposal(proposal);
				}
			} else if (msg_refuse != null) {
				action = (Action) manager.extractContent(msg_propose);
				if (action.getAction() instanceof Proposal) {
					proposal = (Proposal) action.getAction();
					this.myAgent.receiveRefusePropoasl(proposal);
				}
			} else
				block();
		} catch (Exception e) {
		}
	}
}
