package organization.operation.sales;

import organization.communicationOntology.Proposal;

import organization.operation.setting;
import organization.communicationOntology.Inquiry;

public class InquiryManagement {
	private SalesManager sm;

	public InquiryManagement(SalesManager _sm) {
		this.sm = _sm;
	}

	//߻᪺TؤAĤ@تBĤGؼBĤTظ߻
	//oOFPؤ覡AĤ@رĹw]覡AĤGرļ覡
	public void receiveInquiry(Inquiry _inquiry, int _op_propose, int _op_OFP) {
		this.sm.recordInquiry(_inquiry);
		if (_op_propose == setting.PROPOSE_DIRECTLY)
			response2InquiryDirectly(_inquiry, _op_OFP);
		else if (_op_propose == setting.PROPOSE_AFTER_SIMULATION)
			response2InquiryAfterSimulation(_inquiry, _op_OFP);
		else if (_op_propose == setting.PROPOSE_AFTER_FURTHER_INQUIRY)
			Response2InquiryAfterPlanning(_inquiry, _op_OFP);
	}

	private void response2InquiryDirectly(Inquiry _inquiry, int _op_OFP) {
		Proposal proposal = this.sm.generateDirectProposal(_inquiry, _op_OFP);
		this.sm.recordProposal(proposal);
		this.sm.deliverProposal(proposal);
	}

	private void response2InquiryAfterSimulation(Inquiry _inquiry, int _op_OFP) {
		Proposal proposal = this.sm
				.generateSimulatedProposal(_inquiry, _op_OFP);
		this.sm.recordProposal(proposal);
		this.sm.deliverProposal(proposal);
	}

	private void Response2InquiryAfterPlanning(Inquiry _inquiry, int _op_OFP) {
		this.sm.response2InquiryAfterPlanning(_inquiry, _op_OFP);
	}

}
