package organization.beliefSystem;

import java.io.Serializable;

public class modifiedAGNES implements Serializable {
	public int[][] optimalMatrix;

	public modifiedAGNES() {

	}

	public void getOptimallyClusteredMatrix(int[][] _M) {
		int x = _M.length; //data sequence
		int y = _M[0].length; //data items
		int[] ts = new int[_M[0].length];
		int[][][] MMemory = new int[y][x][y];
		float[] totalVarMemory = new float[y];
		int[][] tsMemory = new int[y][y];
		int N = y;
		int i = 0;
		int[][] Mi = _M;
		for (int t = 0; t < ts.length; t++)
			ts[t] = t;

		while (N > 0) {
			float[] vi = getVariance(Mi);
			MMemory[i] = Mi;
			totalVarMemory[i] = getTotal(vi);
			int[] tsc = (int[]) ts.clone();
			tsMemory[i] = tsc;

			int[][] M = getMergenceTrial(Mi);
			float[] v = getVariance(M);

			int mergingPoint = pickUpBestMergeNo(vi, v, N);
			Mi = doMergence(Mi, mergingPoint);
			ts = adjustTimeSlot(mergingPoint, ts);
			i++;
			N--;
		}
		int bestPolicy = pickUpMinNo(totalVarMemory);
		this.optimalMatrix = degenerateMatrix(MMemory[bestPolicy],
				tsMemory[bestPolicy]);
	}

	private float getVariance(int[] _v) {
		float total = 0;
		float mean;
		for (int i = 0; i < _v.length; i++)
			total += _v[i];
		mean = total / _v.length;
		total = 0;
		for (int i = 0; i < _v.length; i++)
			total += Math.pow(_v[i] - mean, 2);
		return (total / _v.length);
	}

	private float[] getVariance(int[][] _M) {
		int[][] T = getTranspose(_M);
		float[] var = new float[_M[0].length];
		for (int i = 0; i < _M[0].length; i++)
			var[i] = getVariance(T[i]);
		return var;
	}

	private int[][] getTranspose(int[][] _M) {
		int[][] T = new int[_M[0].length][_M.length];
		for (int i = 0; i < _M.length; i++)
			for (int j = 0; j < _M[0].length; j++)
				T[j][i] = _M[i][j];
		return T;
	}

	private int[][] getMergenceTrial(int[][] _M) {
		int[][] MERGENCE = new int[_M.length][_M[0].length - 1];
		for (int i = 0; i < _M.length; i++)
			for (int j = 0; j < _M[0].length - 1; j++)
				MERGENCE[i][j] = _M[i][j] + _M[i][j + 1];
		return MERGENCE;
	}

	private int[][] doMergence(int[][] _M, int _pos) {
		int[][] MERGENCE = new int[_M.length][_M[0].length];
		for (int i = 0; i < _M.length; i++) {
			for (int j = 0; j < _M[0].length - 1; j++)
				if (j < _pos)
					MERGENCE[i][j] = _M[i][j];
				else if (j == _pos)
					MERGENCE[i][j] = _M[i][j] + _M[i][j + 1];
				else
					MERGENCE[i][j] = _M[i][j + 1];
			MERGENCE[i][_M[0].length - 1] = 0;
		}
		return MERGENCE;
	}

	private int pickUpMinNo(float[] _v) {
		int minNo = 0;
		float min = _v[0];
		for (int i = 0; i < _v.length; i++) {
			if (Math.min(min, _v[i]) == _v[i]) {
				min = _v[i];
				minNo = i;
			}
		}
		return minNo;
	}

	private float getTotal(float[] _v) {
		float total = 0;
		for (int i = 0; i < _v.length; i++)
			total += _v[i];
		return total;
	}

	private int pickUpBestMergeNo(float[] _original, float[] _merged, int _N) {
		int maxNo = 0;
		float max = _original[0] + _original[1] - _merged[0];
		for (int i = 0; i < _N - 1; i++) {
			float advance = _original[i] + _original[i + 1] - _merged[i];
			if (Math.max(advance, max) == advance) {
				max = advance;
				maxNo = i;
			}
		}
		return maxNo;
	}

	private int[][] degenerateMatrix(int[][] _M, int[] _ts) {
		int bound = _ts.length;
		for (int i = 1; i < _ts.length; i++) {
			if (_ts[i] == -1) {
				bound = i;
				break;
			}
		}
		int[][] DM = new int[_M.length + 1][bound];
		for (int i = 0; i < _M.length; i++)
			for (int j = 0; j < bound; j++)
				DM[i][j] = _M[i][j];
		for (int j = 0; j < bound; j++)
			DM[_M.length][j] = _ts[j];
		return DM;
	}

	private int[] adjustTimeSlot(int _mPoint, int[] _ts) {
		for (int i = _mPoint; i < _ts.length - 1; i++)
			_ts[i] = _ts[i + 1];
		_ts[_ts.length - 1] = -1;
		return _ts;
	}

	public int forecastDemand(int _clusterNo, int _accumulatedDemand) {
		int populationSize = this.optimalMatrix.length - 1;
		int sum = 0;
		for (int i = 0; i < populationSize; i++)
			sum += this.optimalMatrix[i][_clusterNo];
		return (sum / (populationSize));
	}

	private void dumpMatrix(int[][] _M) {
		System.out.println("----------------------------");
		for (int i = 0; i < _M.length; i++) {
			for (int j = 0; j < _M[0].length; j++)
				System.out.print(_M[i][j] + ",");
			System.out.println();
		}
		System.out.println("++++++++++++++++++++++++++++");
	}
}
