package organization.jade.behaviour;

import jade.core.behaviours.*;
import organization.PhysicalAgentImpl;
import organization.communicationOntology.*;

public class ObjectListening extends CyclicBehaviour {

	protected PhysicalAgentImpl myAgent;

	public ObjectListening(PhysicalAgentImpl _a) {
		super(_a);
		this.myAgent = _a;
	}

	public void action() {
		Object[] obj = (Object[]) this.myAgent.getO2AObject();
		if (obj != null) {
			Object obj0 = obj[0];
			if (obj0 instanceof Inquiry) {
				Inquiry inq = (Inquiry) obj0;
				myAgent.deliverInquiry(inq);
			}
			if (obj0 instanceof Order) {
				Order order = (Order) obj0;
				myAgent.deliverOrder(order);
			}
			if (obj0 instanceof Proposal) {
				Proposal proposal = (Proposal) obj0;
				myAgent.deliverProposal(proposal);
			}
			if (obj0 instanceof OrderAcknowledgement) {
				OrderAcknowledgement oa = (OrderAcknowledgement) obj0;
				myAgent.deliverOrderAcknowledgement(oa);
			}
			if (obj0 instanceof GoodsDelivery) {
				GoodsDelivery gd = (GoodsDelivery) obj0;
				myAgent.deliverGoods(gd);
			}
			if (obj0 instanceof Time) {
				myAgent.addBehaviour(new TimeMsgAckDelivering(myAgent));
			}
		} else {
			block();
		}
	}

}
