package organization.jade.behaviour;

import jade.core.*;
import jade.core.behaviours.OneShotBehaviour;

import jade.content.lang.Codec;
import jade.content.onto.*;
import jade.content.lang.sl.*;
import jade.content.onto.basic.*;

import jade.lang.acl.ACLMessage;

import organization.*;
import organization.communicationOntology.*;

public class ProposalDelivering extends OneShotBehaviour {
	private Codec codec = new SLCodec();

	private Ontology ontology = CommunicationOntology.getInstance();

	private PhysicalAgentImpl myAgent;

	private Proposal proposal;

	public ProposalDelivering(PhysicalAgentImpl a, Proposal _proposal) {
		super(a);
		this.proposal = _proposal;
	}

	public void action() {
		Company customer;
		ACLMessage proposeMsg;
		customer = this.proposal.getInquiry().getReceiver();
		AID customer_agent = new AID(customer.getAgentName(), AID.ISLOCALNAME);
		Action action = new Action();
		action.setActor(customer_agent);
		//		    action.setAction(proposal);

		if (this.proposal.getCounter() == null) {
			proposeMsg = new ACLMessage(ACLMessage.REFUSE);
		} else
			proposeMsg = new ACLMessage(ACLMessage.PROPOSE);

		proposeMsg.addReceiver(customer_agent);
		proposeMsg.setLanguage(codec.getName());
		proposeMsg.setOntology(ontology.getName());

		try {
			this.myAgent.getContentManager().fillContent(proposeMsg, action);
			this.myAgent.send(proposeMsg);
		} catch (Exception pe) {
			System.out.println(pe.getMessage());
		}
	}
}
