package organization.jade.behaviour;

import organization.PhysicalAgentImpl;
import organization.communicationOntology.*;

import jade.content.lang.Codec;
import jade.content.lang.sl.SLCodec;
import jade.content.onto.Ontology;
import jade.content.onto.basic.Action;
import jade.core.AID;
import jade.core.behaviours.OneShotBehaviour;
import jade.lang.acl.ACLMessage;
import organization.dataschema.Clock;

public class TimeMsgAckDelivering extends OneShotBehaviour{

	  private Codec codec = new SLCodec();
	  private Ontology ontology = CommunicationOntology.getInstance();

	  protected PhysicalAgentImpl myAgent;

	  public TimeMsgAckDelivering(PhysicalAgentImpl a) {
		  super(a);
		  myAgent = a;
	  }

	  public void action() {
		  Time time = new Time(Clock.getPeriod(), Clock.getSlot());
		  AID receiverAgent = new AID("T", AID.ISLOCALNAME);
		  Action action = new Action();
		  action.setActor(receiverAgent);
		  action.setAction(time);	
		  		  
		  ACLMessage msg = new ACLMessage(ACLMessage.CONFIRM);	    
		  msg.addReceiver(receiverAgent);
		  msg.setLanguage(codec.getName());
		  msg.setOntology(ontology.getName());
		  try {
			  myAgent.getContentManager().fillContent(msg, action);
			  myAgent.send(msg);
		  } catch (Exception pe) {
		      System.out.println(pe.getMessage());
		  }
	  }
}
