package organization.operation.database;

import java.util.List;
import java.util.ArrayList;
import organization.dataschema.*;
import organization.operation.Department;
import organization.operation.OperationHub;
import organization.beliefSystem.dataschema.*;
import organization.communicationOntology.*;

public class DataManager extends Department{
	public List receivedInquiries;
	public List receivedOrders;
	public List receivedProposal;
	public List receivedGoods;
	
	public List deliveredOrders;
	public List deliveredProposal;
	public List deliveredInquiries;
	public List deliveredGoods;
	
	public List inhouseActivities;

	
	public DataManager(OperationHub _ipi) {
		super(_ipi);
		receivedInquiries = new ArrayList(); 
		receivedOrders = new ArrayList();
		receivedProposal = new ArrayList();
		receivedGoods = new ArrayList();
		
		deliveredInquiries = new ArrayList();
		deliveredProposal = new ArrayList();
		deliveredOrders = new ArrayList();
		deliveredGoods = new ArrayList();
		inhouseActivities = new ArrayList();
		
		initializeInhouseDataStorage();
	}
	
	private void initializeInhouseDataStorage() {
		List memory = org.sa.swarmModel.self.memory;
		int timePeriodLength = org.sa.swarmModel.timePeriodLength;
		for (int i=0; i<memory.size(); i++){			
			DataO ro = (DataO) memory.get(i);
			String cusName = ro.cusName;
			String pName = ro.pName;
			String spec = ro.spec;
			classInhouseData cid = new classInhouseData(timePeriodLength, cusName,
					pName, spec);
			inhouseActivities.add(cid);
		}
	}
	
	public void storeInhouseData(InhouseData _iData, classInhouseRecord _cir) {
		int t = _iData.t;
		String cusName = _iData.customerName;
		String pName = _iData.pName;
		String spec = _iData.spec;
		for (int i=0; i<inhouseActivities.size(); i++){	
			classInhouseData cid = (classInhouseData) inhouseActivities.get(i);
			if (cusName.equals(cid.cusName)&pName.equals(cid.pName)&
					spec.equals(cid.spec)){
				cid.addNewInhouseRecord(t, _cir);
				break;
			}
		}
	}
	
	public Order getOriginalOrder(classInhouseData _cid, int _t){
		Order order = null;
		String cusName = _cid.cusName;
		String pName = _cid.pName;
		String spec = _cid.spec;
		int requestedQuantity = _cid.cir[_t].requestedQuantity;
		for (int i=0; i<receivedOrders.size();i++){
			order = (Order) receivedOrders.get(i);
			int tO = Clock.getPeriod(order.getOrderPlacingDatetime());
			int requestedQuantityO = order.getAgreedProposal().getTotalQuantity();
			String pNameO = order.getInquiry().getActivity().getName();
			String specO = order.getInquiry().getActivity().getSpec();
			String cusNameO = order.getInquiry().getSender().getName();
			if ((cusName.equals(cusNameO))&(pName.equals(pNameO))&
					(spec.equals(specO))&(_t==tO)&(requestedQuantity==requestedQuantityO)){
				return order;
			}
		}
		return order;
	}
	
}
