package organization.operation.sales;

import organization.communicationOntology.CompleteDeliveryPlan;
import organization.communicationOntology.Order;
import organization.communicationOntology.Proposal;
import organization.communicationOntology.Inquiry;
import organization.dataschema.*;

public class ProposalManagement {
	private SalesManager sm;

	public ProposalManagement(SalesManager _sm) {
		this.sm = _sm;
	}

	public Proposal generateDirectProposal(Object _obj, int _op_OFP) {
		return null;
	}

	public Proposal generateSimulatedProposal(Object _obj, int _op_OFP) {
		Inquiry inquiry = getInquiry(_obj);
		classProject cp = this.sm.getOFP(inquiry, _op_OFP);

		Proposal proposal = translateProject2Proposal(cp);
		return proposal;
	}

	//not finished
	public Proposal generatePreciseProposal(Proposal _proposal) {
		classProject cp = this.sm.getRecordedClassProject(_proposal);
		cp = this.sm.getRecordedAllActivity(cp);
		Proposal proposal = translateProject2Proposal(cp);
		return proposal;
	}

	public void receiveCounterProposal(Proposal _counterProposal) {
		this.sm.recordCounterProposal(_counterProposal);
		Proposal newProposal = this.sm
				.response2CounterProposal(_counterProposal);
		this.sm.deliverProposal(newProposal);

	}

	private Inquiry getInquiry(Object _obj) {
		Inquiry inquiry = null;
		if (_obj instanceof Inquiry)
			inquiry = (Inquiry) _obj;
		else if (_obj instanceof Order)
			inquiry = ((Order) _obj).getInquiry();
		return inquiry;
	}

	private Proposal translateProject2Proposal(classProject _cp) {
		String current = Clock.getTime();

		String datetime = _cp.endingDatetime;
		int quantity = _cp.quantityAvailable;
		int price = _cp.price;
		float qualityLevel = _cp.getInquiry().getQualityLevel();
		Inquiry inquiry = _cp.getInquiry();
		CompleteDeliveryPlan cdp = new CompleteDeliveryPlan(datetime, quantity,
				price);
		Proposal proposal = new Proposal(inquiry, current, cdp, qualityLevel);
		return proposal;
	}

}
