package jade;

import jade.core.Runtime;
import jade.core.Profile;
import jade.core.ProfileImpl;

import jade.wrapper.*;

public class JadeAgentContainerInitiator {
  private Runtime rt;
  private Profile pMain;

  private AgentContainer ac;
  private AgentController sniffer;
  
  public JadeAgentContainerInitiator(String _hostName, int _port, 
		  String _containerName) {
	  try {
	      this.rt = Runtime.instance();
	      this.rt.setCloseVM(true);
	      this.pMain = new ProfileImpl(_hostName, _port,null);
	      this.pMain.setParameter(Profile.CONTAINER_NAME, _containerName);
	      this.ac = (AgentContainer) rt.createAgentContainer(pMain);
	  }
	  catch(Exception e) {
	      e.printStackTrace();
	  }
  }
  
  public void registerAgent(String _agentName, String _agentClassName, Object[] _receivers) {
	  try {
		  AgentController agent = ac.createNewAgent(_agentName, _agentClassName, _receivers);
		  agent.start();
	  }
	  catch(Exception e) {
	      e.printStackTrace();
	  }
  }
  
  public void snifferingAllAgents() {
	  try {
	      this.sniffer = ac.createNewAgent("sniffer", "jade.tools.sniffer.Sniffer", new Object[0]);
	      this.sniffer.start();
	  }
	  catch(Exception e) {
	      e.printStackTrace();
	  }
  }  	  	    
  
  public void destoryAgentContainer() {
	  try {
		  System.out.println(this.ac.getPlatformName());
		  this.ac.kill();
		  ac.notifyAll();
	    }
	    catch(Exception e) {
	        e.printStackTrace();
	    }	    
  }
}